/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerWriter
extends PrintWriter {
    public LoggerWriter(Logger logger, Level level) {
        super(new InternalWriter(logger, level));
    }

    private static class InternalWriter
    extends Writer {
        private final Logger logger;
        private final Level level;

        public InternalWriter(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        @Override
        public void write(char[] chars, int offset, int len) throws IOException {
            while (len > 0 && (chars[len - 1] == '\n' || chars[len - 1] == '\r')) {
                --len;
            }
            if (len > 0) {
                this.logger.log((Priority)this.level, (Object)String.copyValueOf(chars, offset, len));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

