/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.kafka;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;

public class ZooKeeperLocal {
    private int zkPort;
    private ZooKeeperServer zookeeper;
    private NIOServerCnxnFactory factory;
    File dir;

    public ZooKeeperLocal(int zkPort) {
        int numConnections = 5000;
        int tickTime = 2000;
        this.zkPort = zkPort;
        String dataDirectory = "target";
        this.dir = new File(dataDirectory, "zookeeper").getAbsoluteFile();
        try {
            this.zookeeper = new ZooKeeperServer(this.dir, this.dir, tickTime);
            this.factory = new NIOServerCnxnFactory();
            this.factory.configure(new InetSocketAddress("127.0.0.1", zkPort), 0);
            this.factory.startup(this.zookeeper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void stopZookeeper() throws IOException {
        this.zookeeper.shutdown();
        this.factory.shutdown();
        FileUtils.deleteDirectory((File)this.dir);
    }

    public String getConnectString() {
        return "127.0.0.1:" + this.zkPort;
    }
}

