/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.kafka;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import kafka.message.MessageAndMetadata;
import org.apache.sqoop.common.test.kafka.KafkaConsumer;
import org.apache.sqoop.common.test.kafka.KafkaLocal;
import org.apache.sqoop.common.test.kafka.ZooKeeperLocal;
import org.apache.sqoop.common.test.utils.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestUtil.class);
    private static TestUtil instance = new TestUtil();
    private Random randPortGen = new Random(System.currentTimeMillis());
    private KafkaLocal kafkaServer;
    private ZooKeeperLocal zookeeperServer;
    private KafkaConsumer kafkaConsumer;
    private String hostname = "localhost";
    private int kafkaLocalPort = 9022;
    private int zkLocalPort = 2188;

    private TestUtil() {
        this.init();
    }

    public static TestUtil getInstance() {
        return instance;
    }

    private void init() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Error getting the value of localhost. Proceeding with 'localhost'.", (Throwable)e);
        }
    }

    private boolean startKafkaServer() throws IOException {
        this.kafkaLocalPort = NetworkUtils.findAvailablePort();
        this.zkLocalPort = NetworkUtils.findAvailablePort();
        logger.info("Starting kafka server with kafka port " + this.kafkaLocalPort + " and zookeeper port " + this.zkLocalPort);
        try {
            this.zookeeperServer = new ZooKeeperLocal(this.zkLocalPort);
            logger.info("ZooKeeper instance is successfully started on port " + this.zkLocalPort);
            Properties kafkaProperties = this.getKafkaProperties();
            this.kafkaServer = new KafkaLocal(kafkaProperties);
            this.kafkaServer.start();
            logger.info("Kafka Server is successfully started on port " + this.kafkaLocalPort);
            return true;
        }
        catch (Exception e) {
            logger.error("Error starting the Kafka Server.", (Throwable)e);
            return false;
        }
    }

    Properties getKafkaProperties() {
        Properties kafkaProps = new Properties();
        kafkaProps.put("broker.id", "0");
        kafkaProps.put("port", Integer.toString(this.kafkaLocalPort));
        kafkaProps.put("log.dirs", "target/kafka-logs");
        kafkaProps.put("num.partitions", "1");
        kafkaProps.put("zookeeper.connect", this.zookeeperServer.getConnectString());
        return kafkaProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaConsumer getKafkaConsumer() {
        TestUtil testUtil = this;
        synchronized (testUtil) {
            if (this.kafkaConsumer == null) {
                this.kafkaConsumer = new KafkaConsumer();
            }
        }
        return this.kafkaConsumer;
    }

    public void initTopicList(List<String> topics) {
        this.getKafkaConsumer().initTopicList(topics);
    }

    public MessageAndMetadata getNextMessageFromConsumer(String topic) {
        return this.getKafkaConsumer().getNextMessage(topic);
    }

    public void prepare() throws IOException {
        boolean startStatus = this.startKafkaServer();
        if (!startStatus) {
            throw new RuntimeException("Error starting the server!");
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getKafkaConsumer();
        logger.info("Completed the prepare phase.");
    }

    public void tearDown() throws IOException {
        logger.info("Shutting down the Kafka Consumer.");
        this.getKafkaConsumer().shutdown();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("Shutting down the kafka Server.");
        this.kafkaServer.stop();
        logger.info("Shutting down Zookeeper Server.");
        this.zookeeperServer.stopZookeeper();
        logger.info("Completed the tearDown phase.");
    }

    public String getZkUrl() {
        return this.zookeeperServer.getConnectString();
    }

    public String getKafkaServerUrl() {
        return "localhost:" + this.kafkaLocalPort;
    }
}

