/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.db.types;

import java.util.LinkedList;
import java.util.List;
import org.apache.sqoop.common.test.db.types.ExampleValue;

public class DatabaseType {
    public final String name;
    public final List<ExampleValue> values;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public DatabaseType(String name, List<ExampleValue> values) {
        this.name = name;
        this.values = values;
    }

    public String toString() {
        return this.name;
    }

    public String[] escapedStringValues() {
        String[] ret = new String[this.values.size()];
        int i = 0;
        for (ExampleValue value : this.values) {
            ret[i++] = value.escapedStringValue;
        }
        return ret;
    }

    public static class Builder {
        private String name;
        List<ExampleValue> values;

        public Builder(String name) {
            this.name = name;
            this.values = new LinkedList<ExampleValue>();
        }

        public Builder addExample(String insertStatement, Object objectValue, String escapedStringValue) {
            this.values.add(new ExampleValue(insertStatement, objectValue, escapedStringValue));
            return this;
        }

        public DatabaseType build() {
            return new DatabaseType(this.name, this.values);
        }
    }
}

