/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.db;

import org.apache.sqoop.common.test.db.DatabaseProvider;

public class OracleProvider
extends DatabaseProvider {
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    private static final String CONNECTION = System.getProperties().getProperty("sqoop.provider.oracle.jdbc", "jdbc:oracle:thin:@//localhost/xe");
    private static final String USERNAME = System.getProperties().getProperty("sqoop.provider.oracle.username", "sqoop");
    private static final String PASSWORD = System.getProperties().getProperty("sqoop.provider.oracle.password", "sqoop");

    @Override
    public String getConnectionUrl() {
        return CONNECTION;
    }

    @Override
    public String getConnectionUsername() {
        return USERNAME;
    }

    @Override
    public String getConnectionPassword() {
        return PASSWORD;
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeSchemaName(String schemaName) {
        return this.escape(schemaName);
    }

    @Override
    public String escapeValueString(String value) {
        return "'" + value + "'";
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    public String escape(String entity) {
        return "\"" + entity + "\"";
    }
}

