/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.db;

import org.apache.sqoop.common.test.db.DatabaseProvider;

public class HiveProvider
extends DatabaseProvider {
    public static final String DRIVER = "org.apache.hive.jdbc.HiveDriver";
    private static final String CONNECTION = System.getProperties().getProperty("sqoop.provider.hive.jdbc", "jdbc:hive2://");
    private static final String USERNAME = System.getProperties().getProperty("sqoop.provider.hive.username", "sqoop");
    private static final String PASSWORD = System.getProperties().getProperty("sqoop.provider.hive.password", "sqoop");
    private String jdbcUrl;

    public HiveProvider() {
        this.jdbcUrl = CONNECTION;
    }

    public HiveProvider(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public String getConnectionUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getConnectionUsername() {
        return USERNAME;
    }

    @Override
    public String getConnectionPassword() {
        return PASSWORD;
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeValueString(String value) {
        return this.escape(value);
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    public String escape(String entity) {
        return entity;
    }
}

