/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.db;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.db.DatabaseProvider;
import org.apache.sqoop.common.test.db.types.DatabaseTypeList;
import org.apache.sqoop.common.test.db.types.DerbyTypeList;
import org.apache.sqoop.common.test.utils.LoggerWriter;
import org.apache.sqoop.common.test.utils.NetworkUtils;

public class DerbyProvider
extends DatabaseProvider {
    private static final Logger LOG = Logger.getLogger(DerbyProvider.class);
    public static final String DRIVER = "org.apache.derby.jdbc.ClientDriver";
    int port;
    NetworkServerControl server = null;
    boolean started = false;

    @Override
    public void start() {
        try {
            this.port = NetworkUtils.findAvailablePort();
            LOG.info((Object)("Will bind to port " + this.port));
            this.server = new NetworkServerControl(InetAddress.getByName("localhost"), this.port);
            this.server.start((PrintWriter)new LoggerWriter(LOG, Level.INFO));
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Object> future = executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (true) {
                        try {
                            DerbyProvider.this.server.ping();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Could not ping derby server on port " + DerbyProvider.this.port), (Throwable)e);
                            Thread.sleep(1000L);
                            continue;
                        }
                        break;
                    }
                    return null;
                }
            });
            future.get(10L, TimeUnit.SECONDS);
            this.started = true;
        }
        catch (Exception e) {
            String message = "Can't start embedded Derby server";
            LOG.fatal((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.started) {
                this.server.shutdown();
            }
        }
        catch (Exception e) {
            String message = "Can't shut down embedded Derby server";
            LOG.fatal((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeSchemaName(String schemaName) {
        return this.escape(schemaName);
    }

    @Override
    public String escapeValueString(String value) {
        return "'" + value + "'";
    }

    @Override
    public boolean isSupportingScheme() {
        return true;
    }

    public String escape(String entity) {
        return "\"" + entity + "\"";
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    @Override
    public String getConnectionUrl() {
        return "jdbc:derby://localhost:" + this.port + "/memory:sqoop;create=true";
    }

    @Override
    public String getConnectionUsername() {
        return null;
    }

    @Override
    public String getConnectionPassword() {
        return null;
    }

    @Override
    public DatabaseTypeList getDatabaseTypes() {
        return new DerbyTypeList();
    }
}

