/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.db.TableName;
import org.apache.sqoop.common.test.db.types.DatabaseTypeList;
import org.apache.sqoop.common.test.db.types.EmptyTypeList;

public abstract class DatabaseProvider {
    private static final Logger LOG = Logger.getLogger(DatabaseProvider.class);
    private Connection databaseConnection;

    public abstract String getConnectionUrl();

    public abstract String getConnectionUsername();

    public abstract String getConnectionPassword();

    public abstract String escapeColumnName(String var1);

    public abstract String escapeTableName(String var1);

    public String escapeSchemaName(String schemaName) {
        if (!this.isSupportingScheme()) {
            throw new UnsupportedOperationException("Schema is not supported in this database");
        }
        return schemaName;
    }

    public abstract String escapeValueString(String var1);

    public String nullConstant() {
        return "NULL";
    }

    public boolean isSupportingScheme() {
        return false;
    }

    public String getJdbcDriver() {
        return null;
    }

    public DatabaseTypeList getDatabaseTypes() {
        return new EmptyTypeList();
    }

    public void start() {
        if (this.getJdbcDriver() != null) {
            this.loadClass(this.getJdbcDriver());
        }
        try {
            this.setConnection(DriverManager.getConnection(this.getConnectionUrl(), this.getConnectionUsername(), this.getConnectionPassword()));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't create connection", (Throwable)e);
            throw new RuntimeException("Can't create connection", e);
        }
    }

    public void stop() {
        if (this.databaseConnection != null) {
            try {
                this.databaseConnection.close();
            }
            catch (SQLException e) {
                LOG.info((Object)"Ignored exception on closing connection", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    protected void setConnection(Connection connection) {
        this.databaseConnection = connection;
    }

    public void executeUpdate(String query) {
        LOG.info((Object)("Executing query: " + query));
        Statement stmt = null;
        try {
            stmt = this.databaseConnection.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error in executing query", (Throwable)e);
            throw new RuntimeException("Error in executing query", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LOG.info((Object)"Cant' close statement", (Throwable)e);
            }
        }
    }

    public ResultSet executeQuery(String query) {
        LOG.info((Object)("Executing query: " + query));
        Statement stmt = null;
        try {
            stmt = this.databaseConnection.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error in executing query", (Throwable)e);
            throw new RuntimeException("Error in executing query", e);
        }
    }

    public Long executeInsertQuery(String query, Object ... args) {
        LOG.info((Object)("Executing query: " + query));
        ResultSet rs = null;
        try {
            PreparedStatement stmt = this.databaseConnection.prepareStatement(query, 1);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof String) {
                    stmt.setString(i + 1, (String)args[i]);
                    continue;
                }
                if (args[i] instanceof Long) {
                    stmt.setLong(i + 1, (Long)args[i]);
                    continue;
                }
                if (args[i] instanceof Boolean) {
                    stmt.setBoolean(i + 1, (Boolean)args[i]);
                    continue;
                }
                stmt.setObject(i + 1, args[i]);
            }
            stmt.execute();
            rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                Long l = rs.getLong(1);
                this.closeResultSetWithStatement(rs);
                return l;
            }
            this.closeResultSetWithStatement(rs);
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)"Error in executing query", (Throwable)e);
                throw new RuntimeException("Error in executing query", e);
            }
            catch (Throwable throwable) {
                this.closeResultSetWithStatement(rs);
                throw throwable;
            }
        }
        return -1L;
    }

    public void createTable(TableName name, String primaryKey, String ... columns) {
        if (columns.length == 0 || columns.length % 2 != 0) {
            throw new RuntimeException("Incorrect number of parameters.");
        }
        this.dropTable(name);
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getTableFragment(name)).append("(");
        LinkedList<String> columnList = new LinkedList<String>();
        for (int i = 0; i < columns.length; i += 2) {
            String column = this.escapeColumnName(columns[i]) + " " + columns[i + 1];
            columnList.add(column);
        }
        sb.append(StringUtils.join(columnList, (String)", "));
        if (primaryKey != null) {
            sb.append(", PRIMARY KEY(").append(this.escapeColumnName(primaryKey)).append(")");
        }
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public void insertRow(TableName tableName, Object ... values) {
        this.insertRow(tableName, true, values);
    }

    public void insertRow(TableName tableName, boolean escapeValues, Object ... values) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.getTableFragment(tableName));
        sb.append(" VALUES (");
        LinkedList<String> valueList = new LinkedList<String>();
        for (Object value : values) {
            valueList.add(escapeValues ? this.convertObjectToQueryString(value) : value.toString());
        }
        sb.append(StringUtils.join(valueList, (String)", "));
        sb.append(")");
        this.executeUpdate(sb.toString());
    }

    public ResultSet getRows(TableName tableName, Object[] conditions) {
        return this.getRows(tableName, true, conditions);
    }

    public ResultSet getRows(TableName tableName, boolean escapeValues, Object[] conditions) {
        if (conditions.length % 2 != 0) {
            throw new RuntimeException("Incorrect number of parameters.");
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        sb.append(this.getTableFragment(tableName));
        LinkedList<String> conditionList = new LinkedList<String>();
        for (int i = 0; i < conditions.length; i += 2) {
            Object columnName = conditions[i];
            Object value = conditions[i + 1];
            if (!(columnName instanceof String)) {
                throw new RuntimeException("Each odd item should be a string with column name.");
            }
            if (value == null) {
                conditionList.add(this.escapeColumnName((String)columnName) + " IS NULL");
                continue;
            }
            conditionList.add(this.escapeColumnName((String)columnName) + " = " + (escapeValues ? this.convertObjectToQueryString(value) : value));
        }
        if (conditionList.size() != 0) {
            sb.append(" WHERE ").append(StringUtils.join(conditionList, (String)" AND "));
        }
        return this.executeQuery(sb.toString());
    }

    public String convertObjectToQueryString(Object value) {
        if (value == null) {
            return this.nullConstant();
        }
        if (value.getClass() == String.class) {
            return this.escapeValueString((String)value);
        }
        return value.toString();
    }

    public void dropTable(TableName tableName) {
        StringBuilder sb = new StringBuilder("DROP TABLE ");
        sb.append(this.getTableFragment(tableName));
        try {
            this.executeUpdate(sb.toString());
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Ignoring exception: " + e));
        }
    }

    public void dropSchema(String schemaName) {
        StringBuilder sb = new StringBuilder("DROP SCHEMA ");
        sb.append(this.escapeSchemaName(schemaName));
        sb.append(" CASCADE");
        try {
            this.executeUpdate(sb.toString());
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Ignoring exception: " + e));
        }
    }

    public long rowCount(TableName tableName) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(*) FROM ");
        sb.append(this.getTableFragment(tableName));
        ResultSet rs = null;
        try {
            rs = this.executeQuery(sb.toString());
            if (!rs.next()) {
                throw new RuntimeException("Row count query did not returned any rows.");
            }
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't get number of rows: ", (Throwable)e);
            throw new RuntimeException("Can't get number of rows: ", e);
        }
        finally {
            this.closeResultSetWithStatement(rs);
        }
    }

    public void closeResultSetWithStatement(ResultSet rs) {
        if (rs != null) {
            try {
                Statement stmt = rs.getStatement();
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                LOG.info((Object)"Ignoring exception: ", (Throwable)e);
            }
        }
    }

    public void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTable(TableName tableName) {
        String query = "SELECT * FROM " + this.getTableFragment(tableName);
        LinkedList<String> list = new LinkedList<String>();
        ResultSet rs = null;
        try {
            int i;
            rs = this.executeQuery(query);
            ResultSetMetaData md = rs.getMetaData();
            for (i = 0; i < md.getColumnCount(); ++i) {
                list.add(md.getColumnName(i + 1));
            }
            LOG.info((Object)("Dumping table " + tableName));
            LOG.info((Object)("|" + StringUtils.join(list, (String)"|") + "|"));
            while (rs.next()) {
                list.clear();
                for (i = 0; i < md.getColumnCount(); ++i) {
                    list.add(rs.getObject(i + 1).toString());
                }
                LOG.info((Object)("|" + StringUtils.join(list, (String)"|") + "|"));
            }
        }
        catch (SQLException e) {
            LOG.info((Object)"Ignoring exception: ", (Throwable)e);
        }
        finally {
            this.closeResultSetWithStatement(rs);
        }
    }

    public String getTableFragment(TableName tableName) {
        if (tableName.getSchemaName() == null) {
            return this.escapeTableName(tableName.getTableName());
        }
        return this.escapeSchemaName(tableName.getSchemaName()) + "." + this.escapeTableName(tableName.getTableName());
    }
}

