/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.asserts;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.db.DatabaseProvider;
import org.apache.sqoop.common.test.db.TableName;
import org.testng.Assert;
import org.testng.AssertJUnit;

public class ProviderAsserts {
    private static final Logger LOG = Logger.getLogger(ProviderAsserts.class);

    public static void assertRow(DatabaseProvider provider, TableName tableName, Object[] conditions, Object ... values) {
        ProviderAsserts.assertRow(provider, tableName, true, conditions, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertRow(DatabaseProvider provider, TableName tableName, boolean escapeValues, Object[] conditions, Object ... values) {
        ResultSet rs = null;
        try {
            rs = provider.getRows(tableName, escapeValues, conditions);
            if (!rs.next()) {
                Assert.fail((String)"No rows found.");
            }
            int i = 1;
            for (Object expectedValue : values) {
                Object actualValue = rs.getObject(i);
                AssertJUnit.assertEquals((String)("Columns do not match on position: " + i), (String)expectedValue.toString(), (String)actualValue.toString());
                ++i;
            }
            if (rs.next()) {
                Assert.fail((String)"Found more than one row.");
            }
            provider.closeResultSetWithStatement(rs);
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)"Unexpected SQLException", (Throwable)e);
                Assert.fail((String)("Unexpected SQLException: " + e));
                provider.closeResultSetWithStatement(rs);
            }
            catch (Throwable throwable) {
                provider.closeResultSetWithStatement(rs);
                throw throwable;
            }
        }
    }

    private ProviderAsserts() {
    }
}

