/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import org.apache.sqoop.client.request.Request;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.MJob;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JobRequest
extends Request {
    public static final String RESOURCE = "v1/job/";
    private static final String ENABLE = "/enable";
    private static final String DISABLE = "/disable";

    public JobBean read(String serverUrl, Long xid) {
        String response = xid == null ? super.get(serverUrl + RESOURCE + "all") : super.get(serverUrl + RESOURCE + xid);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)response);
        JobBean jobBean = new JobBean();
        jobBean.restore(jsonObject);
        return jobBean;
    }

    public ValidationBean create(String serverUrl, MJob job) {
        JobBean jobBean = new JobBean(job);
        JSONObject jobJson = jobBean.extract(false);
        String response = super.post(serverUrl + RESOURCE, jobJson.toJSONString());
        ValidationBean validationBean = new ValidationBean();
        validationBean.restore((JSONObject)JSONValue.parse((String)response));
        return validationBean;
    }

    public ValidationBean update(String serverUrl, MJob job) {
        JobBean jobBean = new JobBean(job);
        JSONObject jobJson = jobBean.extract(false);
        String response = super.put(serverUrl + RESOURCE + job.getPersistenceId(), jobJson.toJSONString());
        ValidationBean validationBean = new ValidationBean();
        validationBean.restore((JSONObject)JSONValue.parse((String)response));
        return validationBean;
    }

    public void delete(String serverUrl, Long id) {
        super.delete(serverUrl + RESOURCE + id);
    }

    public void enable(String serverUrl, Long id, Boolean enabled) {
        if (enabled.booleanValue()) {
            super.put(serverUrl + RESOURCE + id + ENABLE, null);
        } else {
            super.put(serverUrl + RESOURCE + id + DISABLE, null);
        }
    }
}

