/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import org.apache.sqoop.client.request.Request;
import org.apache.sqoop.json.ConnectionBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.MConnection;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ConnectionRequest
extends Request {
    public static final String RESOURCE = "v1/connection/";
    private static final String ENABLE = "/enable";
    private static final String DISABLE = "/disable";

    public ConnectionBean read(String serverUrl, Long xid) {
        String response = xid == null ? super.get(serverUrl + RESOURCE + "all") : super.get(serverUrl + RESOURCE + xid);
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)response);
        ConnectionBean connectionBean = new ConnectionBean();
        connectionBean.restore(jsonObject);
        return connectionBean;
    }

    public ValidationBean create(String serverUrl, MConnection connection) {
        ConnectionBean connectionBean = new ConnectionBean(connection);
        JSONObject connectionJson = connectionBean.extract(false);
        String response = super.post(serverUrl + RESOURCE, connectionJson.toJSONString());
        ValidationBean validationBean = new ValidationBean();
        validationBean.restore((JSONObject)JSONValue.parse((String)response));
        return validationBean;
    }

    public ValidationBean update(String serverUrl, MConnection connection) {
        ConnectionBean connectionBean = new ConnectionBean(connection);
        JSONObject connectionJson = connectionBean.extract(false);
        String response = super.put(serverUrl + RESOURCE + connection.getPersistenceId(), connectionJson.toJSONString());
        ValidationBean validationBean = new ValidationBean();
        validationBean.restore((JSONObject)JSONValue.parse((String)response));
        return validationBean;
    }

    public void delete(String serverUrl, Long id) {
        super.delete(serverUrl + RESOURCE + id);
    }

    public void enable(String serverUrl, Long id, Boolean enabled) {
        if (enabled.booleanValue()) {
            super.put(serverUrl + RESOURCE + id + ENABLE, null);
        } else {
            super.put(serverUrl + RESOURCE + id + DISABLE, null);
        }
    }
}

