/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.client.ClientError;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.client.request.SqoopRequests;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.FrameworkBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.FormUtils;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;

public class SqoopClient {
    private SqoopRequests requests = new SqoopRequests();
    private boolean allConnectors;
    private Map<Long, ResourceBundle> bundles;
    private ResourceBundle frameworkBundle;
    private Map<Long, MConnector> connectors;
    private MFramework framework;

    public SqoopClient(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void setServerUrl(String serverUrl) {
        this.requests.setServerUrl(serverUrl);
        this.clearCache();
    }

    public void setSqoopRequests(SqoopRequests requests) {
        this.requests = requests;
        this.clearCache();
    }

    public void clearCache() {
        this.bundles = new HashMap<Long, ResourceBundle>();
        this.frameworkBundle = null;
        this.connectors = new HashMap<Long, MConnector>();
        this.framework = null;
        this.allConnectors = false;
    }

    public MConnector getConnector(long cid) {
        if (this.connectors.containsKey(cid)) {
            return this.connectors.get(cid).clone(false);
        }
        this.retrieveConnector(cid);
        return this.connectors.get(cid).clone(false);
    }

    public MConnector getConnector(String connectorName) {
        MConnector connector = this.getConnectorFromCache(connectorName);
        if (connector != null) {
            return connector;
        }
        if (this.allConnectors) {
            return null;
        }
        this.getConnectors();
        return this.getConnectorFromCache(connectorName);
    }

    private MConnector getConnectorFromCache(String connectorName) {
        for (MConnector connector : this.connectors.values()) {
            if (!connector.getUniqueName().equals(connectorName)) continue;
            return connector;
        }
        return null;
    }

    private void retrieveConnector(long cid) {
        ConnectorBean request = this.requests.readConnector(cid);
        this.connectors.put(cid, (MConnector)request.getConnectors().get(0));
        this.bundles.put(cid, (ResourceBundle)request.getResourceBundles().get(cid));
    }

    public Collection<MConnector> getConnectors() {
        if (this.allConnectors) {
            return this.connectors.values();
        }
        ConnectorBean bean = this.requests.readConnector(null);
        this.allConnectors = true;
        for (MConnector connector : bean.getConnectors()) {
            this.connectors.put(connector.getPersistenceId(), connector);
        }
        this.bundles = bean.getResourceBundles();
        return this.connectors.values();
    }

    public ResourceBundle getResourceBundle(long cid) {
        if (this.bundles.containsKey(cid)) {
            return this.bundles.get(cid);
        }
        this.retrieveConnector(cid);
        return this.bundles.get(cid);
    }

    public MFramework getFramework() {
        if (this.framework != null) {
            return this.framework.clone(false);
        }
        this.retrieveFramework();
        return this.framework.clone(false);
    }

    private void retrieveFramework() {
        FrameworkBean request = this.requests.readFramework();
        this.framework = request.getFramework();
        this.frameworkBundle = request.getResourceBundle();
    }

    public ResourceBundle getFrameworkResourceBundle() {
        if (this.frameworkBundle != null) {
            return this.frameworkBundle;
        }
        this.retrieveFramework();
        return this.frameworkBundle;
    }

    public MConnection newConnection(long cid) {
        return new MConnection(cid, this.getConnector(cid).getConnectionForms(), this.getFramework().getConnectionForms());
    }

    public MConnection newConnection(String connectorName) {
        MConnector connector = this.getConnector(connectorName);
        if (connector == null) {
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0003, connectorName);
        }
        return this.newConnection(connector.getPersistenceId());
    }

    public MConnection getConnection(long xid) {
        return (MConnection)this.requests.readConnection(xid).getConnections().get(0);
    }

    public List<MConnection> getConnections() {
        return this.requests.readConnection(null).getConnections();
    }

    public Status createConnection(MConnection connection) {
        return this.applyValidations(this.requests.createConnection(connection), connection);
    }

    public Status updateConnection(MConnection connection) {
        return this.applyValidations(this.requests.updateConnection(connection), connection);
    }

    public void enableConnection(long xid, boolean enabled) {
        this.requests.enableConnection(xid, enabled);
    }

    public void deleteConnection(long xid) {
        this.requests.deleteConnection(xid);
    }

    public MJob newJob(long xid, MJob.Type type) {
        MConnection connection = this.getConnection(xid);
        return new MJob(connection.getConnectorId(), connection.getPersistenceId(), type, this.getConnector(connection.getConnectorId()).getJobForms(type), this.getFramework().getJobForms(type));
    }

    public MJob getJob(long jid) {
        return (MJob)this.requests.readJob(jid).getJobs().get(0);
    }

    public List<MJob> getJobs() {
        return this.requests.readJob(null).getJobs();
    }

    public Status createJob(MJob job) {
        return this.applyValidations(this.requests.createJob(job), job);
    }

    public Status updateJob(MJob job) {
        return this.applyValidations(this.requests.updateJob(job), job);
    }

    public void enableJob(long jid, boolean enabled) {
        this.requests.enableJob(jid, enabled);
    }

    public void deleteJob(long jid) {
        this.requests.deleteJob(jid);
    }

    public MSubmission startSubmission(long jid) {
        return (MSubmission)this.requests.createSubmission(jid).getSubmissions().get(0);
    }

    public MSubmission startSubmission(long jid, SubmissionCallback callback, long pollTime) throws InterruptedException {
        if (pollTime <= 0L) {
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0002);
        }
        boolean first = true;
        MSubmission submission = (MSubmission)this.requests.createSubmission(jid).getSubmissions().get(0);
        while (submission.getStatus().isRunning()) {
            if (first) {
                this.submissionCallback(callback, submission, SubmissionStatus.SUBMITTED);
                first = false;
            } else {
                this.submissionCallback(callback, submission, SubmissionStatus.UPDATED);
            }
            Thread.sleep(pollTime);
            submission = this.getSubmissionStatus(jid);
        }
        this.submissionCallback(callback, submission, SubmissionStatus.FINISHED);
        return submission;
    }

    private void submissionCallback(SubmissionCallback callback, MSubmission submission, SubmissionStatus status) {
        if (callback == null) {
            return;
        }
        switch (status) {
            case SUBMITTED: {
                callback.submitted(submission);
                break;
            }
            case UPDATED: {
                callback.updated(submission);
                break;
            }
            case FINISHED: {
                callback.finished(submission);
            }
        }
    }

    public MSubmission stopSubmission(long jid) {
        return (MSubmission)this.requests.deleteSubmission(jid).getSubmissions().get(0);
    }

    public MSubmission getSubmissionStatus(long jid) {
        return (MSubmission)this.requests.readSubmission(jid).getSubmissions().get(0);
    }

    public List<MSubmission> getSubmissions() {
        return this.requests.readHistory(null).getSubmissions();
    }

    public List<MSubmission> getSubmissionsForJob(long jid) {
        return this.requests.readHistory(jid).getSubmissions();
    }

    private Status applyValidations(ValidationBean bean, MConnection connection) {
        Validation connector = bean.getConnectorValidation();
        Validation framework = bean.getFrameworkValidation();
        FormUtils.applyValidation((List)connection.getConnectorPart().getForms(), (Validation)connector);
        FormUtils.applyValidation((List)connection.getFrameworkPart().getForms(), (Validation)framework);
        Long id = bean.getId();
        if (id != null) {
            connection.setPersistenceId(id.longValue());
        }
        return Status.getWorstStatus((Status[])new Status[]{connector.getStatus(), framework.getStatus()});
    }

    private Status applyValidations(ValidationBean bean, MJob job) {
        Validation connector = bean.getConnectorValidation();
        Validation framework = bean.getFrameworkValidation();
        FormUtils.applyValidation((List)job.getConnectorPart().getForms(), (Validation)connector);
        FormUtils.applyValidation((List)job.getFrameworkPart().getForms(), (Validation)framework);
        Long id = bean.getId();
        if (id != null) {
            job.setPersistenceId(id.longValue());
        }
        return Status.getWorstStatus((Status[])new Status[]{connector.getStatus(), framework.getStatus()});
    }

    private static enum SubmissionStatus {
        SUBMITTED,
        UPDATED,
        FINISHED;

    }
}

