/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.sqoop.client.request.AuthorizationResourceRequest;
import org.apache.sqoop.client.request.ConnectorResourceRequest;
import org.apache.sqoop.client.request.DriverResourceRequest;
import org.apache.sqoop.client.request.JobResourceRequest;
import org.apache.sqoop.client.request.LinkResourceRequest;
import org.apache.sqoop.client.request.SubmissionResourceRequest;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.DriverBean;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.LinkBean;
import org.apache.sqoop.json.PrincipalsBean;
import org.apache.sqoop.json.PrivilegesBean;
import org.apache.sqoop.json.RolesBean;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.json.SubmissionsBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;

public class SqoopResourceRequests {
    private String serverUrl;
    private DriverResourceRequest driverRequest;
    private ConnectorResourceRequest connectorRequest;
    private LinkResourceRequest linkRequest;
    private JobResourceRequest jobRequest;
    private SubmissionResourceRequest submissionRequest;
    private AuthorizationResourceRequest authorizationRequest;
    private DelegationTokenAuthenticatedURL.Token authToken = new DelegationTokenAuthenticatedURL.Token();

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DriverResourceRequest getDriverResourceRequest() {
        if (this.driverRequest == null) {
            this.driverRequest = new DriverResourceRequest(this.authToken);
        }
        return this.driverRequest;
    }

    public ConnectorResourceRequest getConnectorResourceRequest() {
        if (this.connectorRequest == null) {
            this.connectorRequest = new ConnectorResourceRequest(this.authToken);
        }
        return this.connectorRequest;
    }

    public LinkResourceRequest getLinkResourceRequest() {
        if (this.linkRequest == null) {
            this.linkRequest = new LinkResourceRequest(this.authToken);
        }
        return this.linkRequest;
    }

    public JobResourceRequest getJobResourceRequest() {
        if (this.jobRequest == null) {
            this.jobRequest = new JobResourceRequest(this.authToken);
        }
        return this.jobRequest;
    }

    public SubmissionResourceRequest getSubmissionResourceRequest() {
        if (this.submissionRequest == null) {
            this.submissionRequest = new SubmissionResourceRequest(this.authToken);
        }
        return this.submissionRequest;
    }

    public AuthorizationResourceRequest getAuthorizationRequest() {
        if (this.authorizationRequest == null) {
            this.authorizationRequest = new AuthorizationResourceRequest(this.authToken);
        }
        return this.authorizationRequest;
    }

    public DriverBean readDriver() {
        return this.getDriverResourceRequest().read(this.serverUrl);
    }

    public ConnectorBean readConnector(Long cid) {
        return this.getConnectorResourceRequest().read(this.serverUrl, cid);
    }

    public ValidationResultBean saveLink(MLink link) {
        return this.getLinkResourceRequest().create(this.serverUrl, link);
    }

    public LinkBean readLink(Long linkId) {
        return this.getLinkResourceRequest().read(this.serverUrl, linkId);
    }

    public ValidationResultBean updateLink(MLink link) {
        return this.getLinkResourceRequest().update(this.serverUrl, link);
    }

    public void enableLink(Long lid, Boolean enabled) {
        this.getLinkResourceRequest().enable(this.serverUrl, lid, enabled);
    }

    public void deleteLink(Long lid) {
        this.getLinkResourceRequest().delete(this.serverUrl, lid);
    }

    public ValidationResultBean saveJob(MJob job) {
        return this.getJobResourceRequest().create(this.serverUrl, job);
    }

    public JobBean readJob(Long jobId) {
        return this.getJobResourceRequest().read(this.serverUrl, jobId);
    }

    public JobBean readJobsByConnector(Long cId) {
        return this.getJobResourceRequest().readByConnector(this.serverUrl, cId);
    }

    public ValidationResultBean updateJob(MJob job) {
        return this.getJobResourceRequest().update(this.serverUrl, job);
    }

    public void enableJob(Long jid, Boolean enabled) {
        this.getJobResourceRequest().enable(this.serverUrl, jid, enabled);
    }

    public void deleteJob(Long jid) {
        this.getJobResourceRequest().delete(this.serverUrl, jid);
    }

    public SubmissionBean getJobStatus(Long jid) {
        return this.getJobResourceRequest().status(this.serverUrl, jid);
    }

    public SubmissionBean startJob(Long jid) {
        return this.getJobResourceRequest().start(this.serverUrl, jid);
    }

    public SubmissionBean stopJob(Long jid) {
        return this.getJobResourceRequest().stop(this.serverUrl, jid);
    }

    public SubmissionsBean readSubmission(Long jid) {
        return this.getSubmissionResourceRequest().read(this.serverUrl, jid);
    }

    public RolesBean readRoles() {
        return this.getAuthorizationRequest().readRoles(this.serverUrl);
    }

    public void createRole(MRole role) {
        this.getAuthorizationRequest().createRole(this.serverUrl, role);
    }

    public void dropRole(MRole role) {
        this.getAuthorizationRequest().dropRole(this.serverUrl, role);
    }

    public void grantRole(List<MRole> roles, List<MPrincipal> principals) {
        this.getAuthorizationRequest().grantRevokeRole(this.serverUrl, roles, principals, true);
    }

    public void revokeRole(List<MRole> roles, List<MPrincipal> principals) {
        this.getAuthorizationRequest().grantRevokeRole(this.serverUrl, roles, principals, false);
    }

    public RolesBean readRolesByPrincipal(MPrincipal principal) {
        return this.getAuthorizationRequest().readRolesByPrincipal(this.serverUrl, principal);
    }

    public PrincipalsBean readPrincipalsByRole(MRole role) {
        return this.getAuthorizationRequest().readPrincipalsByRole(this.serverUrl, role);
    }

    public void grantPrivilege(List<MPrincipal> principals, List<MPrivilege> privileges) {
        this.getAuthorizationRequest().grantRevokePrivilege(this.serverUrl, principals, privileges, true);
    }

    public PrivilegesBean readPrivilegesByPrincipal(MPrincipal principal, MResource resource) {
        return this.getAuthorizationRequest().readPrivilegesByPrincipal(this.serverUrl, principal, resource);
    }

    public void revokePrivilege(List<MPrincipal> principals, List<MPrivilege> privileges) {
        this.getAuthorizationRequest().grantRevokePrivilege(this.serverUrl, principals, privileges, false);
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.getDriverResourceRequest().addDelegationTokens(this.serverUrl + "v1/driver/", renewer, credentials);
    }
}

