/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Locale;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.ClientError;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.ThrowableBean;
import org.json.simple.JSONObject;

public class ResourceRequest {
    private static final Logger LOG = Logger.getLogger(ResourceRequest.class);
    private DelegationTokenAuthenticatedURL.Token authToken;

    public ResourceRequest() {
        this.authToken = new DelegationTokenAuthenticatedURL.Token();
    }

    public ResourceRequest(DelegationTokenAuthenticatedURL.Token token) {
        this.authToken = token == null ? new DelegationTokenAuthenticatedURL.Token() : token;
    }

    protected String doHttpRequest(String strURL, String method) {
        return this.doHttpRequest(strURL, method, "");
    }

    protected String doHttpRequest(String strURL, String method, String data) {
        FilterOutputStream wr = null;
        BufferedReader reader = null;
        DelegationTokenAuthenticator dta = null;
        try {
            strURL = this.addUsername(strURL);
            URL url = new URL(strURL);
            String authenticatorClass = System.getProperty("authClass");
            if (null != authenticatorClass) {
                dta = (DelegationTokenAuthenticator)ResourceRequest.class.getClassLoader().loadClass(authenticatorClass).newInstance();
            }
            HttpURLConnection conn = new DelegationTokenAuthenticatedURL(dta, null).openConnection(url, this.authToken);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Language", Locale.getDefault().toString());
            if (method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("POST")) {
                conn.setDoOutput(true);
                data = data == null ? "" : data;
                conn.setRequestProperty("Content-Length", Integer.toString(data.getBytes().length));
                wr = new DataOutputStream(conn.getOutputStream());
                ((DataOutputStream)wr).writeBytes(data);
                ((DataOutputStream)wr).flush();
                wr.close();
            }
            LOG.debug((Object)("Status code: " + conn.getResponseCode() + " " + conn.getResponseMessage()));
            StringBuilder result = new StringBuilder();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    result.append(line);
                    line = reader.readLine();
                }
            } else {
                if (responseCode == 500) {
                    String line;
                    if (conn.getHeaderFields().keySet().contains("sqoop-internal-error-code")) {
                        ThrowableBean ex = new ThrowableBean();
                        result = new StringBuilder();
                        reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                        String line2 = reader.readLine();
                        while (line2 != null) {
                            result.append(line2);
                            line2 = reader.readLine();
                        }
                        reader.close();
                        JSONObject json = JSONUtils.parse((String)result.toString());
                        ex.restore(json);
                        throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, ex.getThrowable());
                    }
                    result = new StringBuilder();
                    reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                        result.append('\n');
                    }
                    reader.close();
                    throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, result.toString());
                }
                throw new SqoopException((ErrorCode)ClientError.CLIENT_0000);
            }
            reader.close();
            String string = result.toString();
            return string;
        }
        catch (IOException ex) {
            LOG.trace((Object)"ERROR: ", (Throwable)ex);
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0000, (Throwable)ex);
        }
        catch (AuthenticationException ex) {
            LOG.trace((Object)"ERROR: ", (Throwable)ex);
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0005, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            LOG.trace((Object)"ERROR: ", (Throwable)ex);
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            LOG.trace((Object)"ERROR: ", (Throwable)ex);
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            LOG.trace((Object)"ERROR: ", (Throwable)ex);
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, (Throwable)ex);
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (IOException e) {
                LOG.trace((Object)"Cannot close DataOutputStream.", (Throwable)e);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.trace((Object)"Cannot close BufferReader.", (Throwable)e);
            }
        }
    }

    public String get(String url) {
        return this.doHttpRequest(url, "GET");
    }

    public String post(String url, String data) {
        return this.doHttpRequest(url, "POST", data);
    }

    public String put(String url, String data) {
        return this.doHttpRequest(url, "PUT", data);
    }

    public String delete(String url) {
        return this.doHttpRequest(url, "DELETE");
    }

    public Token<?>[] addDelegationTokens(String strURL, String renewer, Credentials credentials) throws IOException {
        Token[] tokens = null;
        Text dtService = this.getDelegationTokenService(strURL);
        Token token = credentials.getToken(dtService);
        if (token == null) {
            URL url = new URL(strURL);
            DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(new ConnectionConfigurator(){

                public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                    return conn;
                }
            });
            try {
                token = authUrl.getDelegationToken(url, this.authToken, renewer);
                if (token == null) {
                    throw new IOException("Got NULL as delegation token");
                }
                credentials.addToken(token.getService(), token);
                tokens = new Token[]{token};
            }
            catch (AuthenticationException ex) {
                throw new IOException(ex);
            }
        }
        return tokens;
    }

    private Text getDelegationTokenService(String strURL) throws IOException {
        URL url = new URL(strURL);
        InetSocketAddress addr = new InetSocketAddress(url.getHost(), url.getPort());
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)addr);
        return dtService;
    }

    public DelegationTokenAuthenticatedURL.Token getAuthToken() {
        return this.authToken;
    }

    private String addUsername(String strUrl) {
        String paramSeparator = strUrl.contains("?") ? "&" : "?";
        strUrl = strUrl + paramSeparator + "user.name" + "=" + System.getProperty("user.name");
        return strUrl;
    }
}

