/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.sqoop.client.request.ResourceRequest;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.LinkBean;
import org.apache.sqoop.json.LinksBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.MLink;
import org.json.simple.JSONObject;

public class LinkResourceRequest
extends ResourceRequest {
    public static final String LINK_RESOURCE = "v1/link/";
    private static final String ENABLE = "/enable";
    private static final String DISABLE = "/disable";

    public LinkResourceRequest() {
    }

    public LinkResourceRequest(DelegationTokenAuthenticatedURL.Token token) {
        super(token);
    }

    public LinkBean read(String serverUrl, Long linkId) {
        String response = linkId == null ? super.get(serverUrl + LINK_RESOURCE + "all") : super.get(serverUrl + LINK_RESOURCE + linkId);
        JSONObject jsonObject = JSONUtils.parse((String)response);
        LinksBean bean = new LinksBean();
        if (linkId != null) {
            bean = new LinkBean();
        }
        bean.restore(jsonObject);
        return bean;
    }

    public ValidationResultBean create(String serverUrl, MLink link) {
        LinkBean linkBean = new LinkBean(link);
        JSONObject linkJson = linkBean.extract(false);
        String response = super.post(serverUrl + LINK_RESOURCE, linkJson.toJSONString());
        ValidationResultBean validationBean = new ValidationResultBean();
        validationBean.restore(JSONUtils.parse((String)response));
        return validationBean;
    }

    public ValidationResultBean update(String serverUrl, MLink link) {
        LinkBean linkBean = new LinkBean(link);
        JSONObject linkJson = linkBean.extract(false);
        String response = super.put(serverUrl + LINK_RESOURCE + link.getPersistenceId(), linkJson.toJSONString());
        ValidationResultBean validationBean = new ValidationResultBean();
        validationBean.restore(JSONUtils.parse((String)response));
        return validationBean;
    }

    public void delete(String serverUrl, Long id) {
        super.delete(serverUrl + LINK_RESOURCE + id);
    }

    public void enable(String serverUrl, Long id, Boolean enabled) {
        if (enabled.booleanValue()) {
            super.put(serverUrl + LINK_RESOURCE + id + ENABLE, null);
        } else {
            super.put(serverUrl + LINK_RESOURCE + id + DISABLE, null);
        }
    }
}

