/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.sqoop.client.request.ResourceRequest;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.JobsBean;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.MJob;
import org.json.simple.JSONObject;

public class JobResourceRequest
extends ResourceRequest {
    public static final String RESOURCE = "v1/job/";
    private static final String ENABLE = "/enable";
    private static final String DISABLE = "/disable";
    private static final String START = "/start";
    private static final String STOP = "/stop";
    private static final String STATUS = "/status";

    public JobResourceRequest() {
    }

    public JobResourceRequest(DelegationTokenAuthenticatedURL.Token token) {
        super(token);
    }

    public JobBean readByConnector(String serverUrl, Long cId) {
        JobsBean bean = new JobsBean();
        if (cId != null) {
            String response = super.get(serverUrl + RESOURCE + "?cname=" + cId);
            JSONObject jsonObject = JSONUtils.parse((String)response);
            bean.restore(jsonObject);
        }
        return bean;
    }

    public JobBean read(String serverUrl, Long jobId) {
        String response = jobId == null ? super.get(serverUrl + RESOURCE + "all") : super.get(serverUrl + RESOURCE + jobId);
        JSONObject jsonObject = JSONUtils.parse((String)response);
        JobsBean bean = new JobsBean();
        if (jobId != null) {
            bean = new JobBean();
        }
        bean.restore(jsonObject);
        return bean;
    }

    public ValidationResultBean create(String serverUrl, MJob job) {
        JobBean jobBean = new JobBean(job);
        JSONObject jobJson = jobBean.extract(false);
        String response = super.post(serverUrl + RESOURCE, jobJson.toJSONString());
        ValidationResultBean validationResultBean = new ValidationResultBean();
        validationResultBean.restore(JSONUtils.parse((String)response));
        return validationResultBean;
    }

    public ValidationResultBean update(String serverUrl, MJob job) {
        JobBean jobBean = new JobBean(job);
        JSONObject jobJson = jobBean.extract(false);
        String response = super.put(serverUrl + RESOURCE + job.getPersistenceId(), jobJson.toJSONString());
        ValidationResultBean validationBean = new ValidationResultBean();
        validationBean.restore(JSONUtils.parse((String)response));
        return validationBean;
    }

    public void delete(String serverUrl, Long jobId) {
        super.delete(serverUrl + RESOURCE + jobId);
    }

    public void enable(String serverUrl, Long jobId, Boolean enabled) {
        if (enabled.booleanValue()) {
            super.put(serverUrl + RESOURCE + jobId + ENABLE, null);
        } else {
            super.put(serverUrl + RESOURCE + jobId + DISABLE, null);
        }
    }

    public SubmissionBean start(String serverUrl, Long jobId) {
        String response = super.put(serverUrl + RESOURCE + jobId + START, null);
        return this.createJobSubmissionResponse(response);
    }

    public SubmissionBean stop(String serverUrl, Long jobId) {
        String response = super.put(serverUrl + RESOURCE + jobId + STOP, null);
        return this.createJobSubmissionResponse(response);
    }

    public SubmissionBean status(String serverUrl, Long jobId) {
        String response = super.get(serverUrl + RESOURCE + jobId + STATUS);
        return this.createJobSubmissionResponse(response);
    }

    private SubmissionBean createJobSubmissionResponse(String response) {
        SubmissionBean submissionBean = new SubmissionBean();
        submissionBean.restore(JSONUtils.parse((String)response));
        return submissionBean;
    }
}

