/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.sqoop.client.request.ResourceRequest;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.PrincipalsBean;
import org.apache.sqoop.json.PrivilegesBean;
import org.apache.sqoop.json.RoleBean;
import org.apache.sqoop.json.RolesBean;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.json.simple.JSONObject;

public class AuthorizationResourceRequest
extends ResourceRequest {
    public static final String RESOURCE = "v1/authorization";
    public static final String ROLES = "/roles";
    public static final String PRINCIPALS = "/principals";
    public static final String PRIVILEGES = "/privileges";
    private static final String CREATE = "/create";
    private static final String GRANT = "/grant";
    private static final String REVOKE = "/revoke";

    public AuthorizationResourceRequest() {
    }

    public AuthorizationResourceRequest(DelegationTokenAuthenticatedURL.Token token) {
        super(token);
    }

    public RolesBean readRoles(String serverUrl) {
        String response = super.get(serverUrl + RESOURCE + ROLES);
        JSONObject jsonObject = JSONUtils.parse((String)response);
        RolesBean bean = new RolesBean();
        bean.restore(jsonObject);
        return bean;
    }

    public void createRole(String serverUrl, MRole role) {
        RoleBean roleBean = new RoleBean(role);
        JSONObject roleJson = roleBean.extract(false);
        super.post(serverUrl + RESOURCE + ROLES + CREATE, roleJson.toJSONString());
    }

    public void dropRole(String serverUrl, MRole role) {
        super.delete(serverUrl + RESOURCE + ROLES + "/" + role.getName());
    }

    public void grantRevokeRole(String serverUrl, List<MRole> roles, List<MPrincipal> principals, boolean isGrant) {
        RolesBean rolesBean = new RolesBean(roles);
        PrincipalsBean principalsBean = new PrincipalsBean(principals);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll((Map)rolesBean.extract(false));
        jsonObject.putAll((Map)principalsBean.extract(false));
        if (isGrant) {
            super.put(serverUrl + RESOURCE + ROLES + GRANT, jsonObject.toJSONString());
        } else {
            super.put(serverUrl + RESOURCE + ROLES + REVOKE, jsonObject.toJSONString());
        }
    }

    public RolesBean readRolesByPrincipal(String serverUrl, MPrincipal principal) {
        String response = super.get(serverUrl + RESOURCE + ROLES + "?principal_name=" + principal.getName() + "&principal_type=" + principal.getType());
        JSONObject jsonObject = JSONUtils.parse((String)response);
        RolesBean bean = new RolesBean();
        bean.restore(jsonObject);
        return bean;
    }

    public PrincipalsBean readPrincipalsByRole(String serverUrl, MRole role) {
        String response = super.get(serverUrl + RESOURCE + PRINCIPALS + "?role_name=" + role.getName());
        JSONObject jsonObject = JSONUtils.parse((String)response);
        PrincipalsBean bean = new PrincipalsBean();
        bean.restore(jsonObject);
        return bean;
    }

    public void grantRevokePrivilege(String serverUrl, List<MPrincipal> principals, List<MPrivilege> privileges, boolean isGrant) {
        PrincipalsBean principalsBean = new PrincipalsBean(principals);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll((Map)principalsBean.extract(false));
        if (privileges != null && privileges.size() != 0) {
            PrivilegesBean privilegesBean = new PrivilegesBean(privileges);
            jsonObject.putAll((Map)privilegesBean.extract(false));
        }
        if (isGrant) {
            super.put(serverUrl + RESOURCE + PRIVILEGES + GRANT, jsonObject.toJSONString());
        } else {
            super.put(serverUrl + RESOURCE + PRIVILEGES + REVOKE, jsonObject.toJSONString());
        }
    }

    public PrivilegesBean readPrivilegesByPrincipal(String serverUrl, MPrincipal principal, MResource resource) {
        String url = serverUrl + RESOURCE + PRIVILEGES + "?principal_name=" + principal.getName() + "&principal_type=" + principal.getType();
        if (resource != null) {
            url = url + "&resource_name=" + resource.getName();
            url = url + "&resource_type=" + resource.getType();
        }
        String response = super.get(url);
        JSONObject jsonObject = JSONUtils.parse((String)response);
        PrivilegesBean bean = new PrivilegesBean();
        bean.restore(jsonObject);
        return bean;
    }
}

