/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.client.ClientError;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.client.request.SqoopResourceRequests;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.DriverBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MDriver;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.Status;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SqoopClient {
    private SqoopResourceRequests resourceRequests = new SqoopResourceRequests();
    private boolean isAllConnectors;
    private Map<Long, MConnector> connectors;
    private Map<Long, ResourceBundle> connectorConfigBundles;
    private MDriver mDriver;
    private ResourceBundle driverConfigBundle;

    public SqoopClient(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void setServerUrl(String serverUrl) {
        this.resourceRequests.setServerUrl(serverUrl);
        this.clearCache();
    }

    public void setSqoopRequests(SqoopResourceRequests requests) {
        this.resourceRequests = requests;
        this.clearCache();
    }

    public void clearCache() {
        this.connectorConfigBundles = new HashMap<Long, ResourceBundle>();
        this.driverConfigBundle = null;
        this.connectors = new HashMap<Long, MConnector>();
        this.mDriver = null;
        this.isAllConnectors = false;
    }

    public MConnector getConnector(long cid) {
        if (this.connectors.containsKey(cid)) {
            return this.connectors.get(cid).clone(false);
        }
        this.retrieveConnector(cid);
        return this.connectors.get(cid).clone(false);
    }

    public MConnector getConnector(String connectorName) {
        MConnector connector = this.getConnectorFromCache(connectorName);
        if (connector != null) {
            return connector;
        }
        if (this.isAllConnectors) {
            return null;
        }
        this.getConnectors();
        return this.getConnectorFromCache(connectorName);
    }

    private MConnector getConnectorFromCache(String connectorName) {
        for (MConnector connector : this.connectors.values()) {
            if (!connector.getUniqueName().equals(connectorName)) continue;
            return connector;
        }
        return null;
    }

    private void retrieveConnector(long cid) {
        ConnectorBean request = this.resourceRequests.readConnector(cid);
        this.connectors.put(cid, (MConnector)request.getConnectors().get(0));
        this.connectorConfigBundles.put(cid, (ResourceBundle)request.getResourceBundles().get(cid));
    }

    public Collection<MConnector> getConnectors() {
        if (this.isAllConnectors) {
            return this.connectors.values();
        }
        ConnectorBean bean = this.resourceRequests.readConnector(null);
        this.isAllConnectors = true;
        for (MConnector connector : bean.getConnectors()) {
            this.connectors.put(connector.getPersistenceId(), connector);
        }
        this.connectorConfigBundles = bean.getResourceBundles();
        return this.connectors.values();
    }

    public ResourceBundle getConnectorConfigBundle(long connectorId) {
        if (this.connectorConfigBundles.containsKey(connectorId)) {
            return this.connectorConfigBundles.get(connectorId);
        }
        this.retrieveConnector(connectorId);
        return this.connectorConfigBundles.get(connectorId);
    }

    public MDriverConfig getDriverConfig() {
        if (this.mDriver != null) {
            return this.mDriver.clone(false).getDriverConfig();
        }
        this.retrieveAndCacheDriver();
        return this.mDriver.clone(false).getDriverConfig();
    }

    public MDriver getDriver() {
        if (this.mDriver != null) {
            return this.mDriver.clone(false);
        }
        this.retrieveAndCacheDriver();
        return this.mDriver.clone(false);
    }

    private void retrieveAndCacheDriver() {
        DriverBean driverBean = this.resourceRequests.readDriver();
        this.mDriver = driverBean.getDriver();
        this.driverConfigBundle = driverBean.getDriverConfigResourceBundle();
    }

    public ResourceBundle getDriverConfigBundle() {
        if (this.driverConfigBundle != null) {
            return this.driverConfigBundle;
        }
        this.retrieveAndCacheDriver();
        return this.driverConfigBundle;
    }

    public MLink createLink(long connectorId) {
        return new MLink(connectorId, this.getConnector(connectorId).getLinkConfig());
    }

    public MLink createLink(String connectorName) {
        MConnector connector = this.getConnector(connectorName);
        if (connector == null) {
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0003, connectorName);
        }
        return this.createLink(connector.getPersistenceId());
    }

    public MLink getLink(long linkId) {
        return (MLink)this.resourceRequests.readLink(linkId).getLinks().get(0);
    }

    public List<MLink> getLinks() {
        return this.resourceRequests.readLink(null).getLinks();
    }

    public Status saveLink(MLink link) {
        return this.applyLinkValidations(this.resourceRequests.saveLink(link), link);
    }

    public Status updateLink(MLink link) {
        return this.applyLinkValidations(this.resourceRequests.updateLink(link), link);
    }

    public void enableLink(long linkId, boolean enabled) {
        this.resourceRequests.enableLink(linkId, enabled);
    }

    public void deleteLink(long linkId) {
        this.resourceRequests.deleteLink(linkId);
    }

    public MJob createJob(long fromLinkId, long toLinkId) {
        MLink fromLink = this.getLink(fromLinkId);
        MLink toLink = this.getLink(toLinkId);
        return new MJob(fromLink.getConnectorId(), toLink.getConnectorId(), fromLink.getPersistenceId(), toLink.getPersistenceId(), this.getConnector(fromLink.getConnectorId()).getFromConfig(), this.getConnector(toLink.getConnectorId()).getToConfig(), this.getDriverConfig());
    }

    public MJob getJob(long jobId) {
        return (MJob)this.resourceRequests.readJob(jobId).getJobs().get(0);
    }

    public List<MJob> getJobs() {
        return this.resourceRequests.readJob(null).getJobs();
    }

    public List<MJob> getJobsByConnector(long cId) {
        return this.resourceRequests.readJobsByConnector(cId).getJobs();
    }

    public Status saveJob(MJob job) {
        return this.applyJobValidations(this.resourceRequests.saveJob(job), job);
    }

    public Status updateJob(MJob job) {
        return this.applyJobValidations(this.resourceRequests.updateJob(job), job);
    }

    public void enableJob(long jid, boolean enabled) {
        this.resourceRequests.enableJob(jid, enabled);
    }

    public void deleteJob(long jobId) {
        this.resourceRequests.deleteJob(jobId);
    }

    public MSubmission startJob(long jobId) {
        return (MSubmission)this.resourceRequests.startJob(jobId).getSubmissions().get(0);
    }

    public MSubmission startJob(long jobId, SubmissionCallback callback, long pollTime) throws InterruptedException {
        if (pollTime <= 0L) {
            throw new SqoopException((ErrorCode)ClientError.CLIENT_0002);
        }
        boolean first = true;
        MSubmission submission = (MSubmission)this.resourceRequests.startJob(jobId).getSubmissions().get(0);
        while (submission.getStatus().isRunning()) {
            if (first) {
                this.invokeSubmissionCallback(callback, submission, SubmissionStatus.SUBMITTED);
                first = false;
            } else {
                this.invokeSubmissionCallback(callback, submission, SubmissionStatus.UPDATED);
            }
            Thread.sleep(pollTime);
            submission = this.getJobStatus(jobId);
        }
        this.invokeSubmissionCallback(callback, submission, SubmissionStatus.FINISHED);
        return submission;
    }

    private void invokeSubmissionCallback(SubmissionCallback callback, MSubmission submission, SubmissionStatus status) {
        if (callback == null) {
            return;
        }
        switch (status) {
            case SUBMITTED: {
                callback.submitted(submission);
                break;
            }
            case UPDATED: {
                callback.updated(submission);
                break;
            }
            case FINISHED: {
                callback.finished(submission);
            }
        }
    }

    public MSubmission stopJob(long jid) {
        return (MSubmission)this.resourceRequests.stopJob(jid).getSubmissions().get(0);
    }

    public MSubmission getJobStatus(long jid) {
        return (MSubmission)this.resourceRequests.getJobStatus(jid).getSubmissions().get(0);
    }

    public List<MSubmission> getSubmissions() {
        return this.resourceRequests.readSubmission(null).getSubmissions();
    }

    public List<MSubmission> getSubmissionsForJob(long jobId) {
        return this.resourceRequests.readSubmission(jobId).getSubmissions();
    }

    public List<MRole> getRoles() {
        return this.resourceRequests.readRoles().getRoles();
    }

    public void createRole(MRole role) {
        this.resourceRequests.createRole(role);
    }

    public void dropRole(MRole role) {
        this.resourceRequests.dropRole(role);
    }

    public void grantRole(List<MRole> roles, List<MPrincipal> principals) {
        this.resourceRequests.grantRole(roles, principals);
    }

    public void revokeRole(List<MRole> roles, List<MPrincipal> principals) {
        this.resourceRequests.revokeRole(roles, principals);
    }

    public List<MRole> getRolesByPrincipal(MPrincipal principal) {
        return this.resourceRequests.readRolesByPrincipal(principal).getRoles();
    }

    public List<MPrincipal> getPrincipalsByRole(MRole role) {
        return this.resourceRequests.readPrincipalsByRole(role).getPrincipals();
    }

    public void grantPrivilege(List<MPrincipal> principals, List<MPrivilege> privileges) {
        this.resourceRequests.grantPrivilege(principals, privileges);
    }

    public void revokePrivilege(List<MPrincipal> principals, List<MPrivilege> privileges) {
        this.resourceRequests.revokePrivilege(principals, privileges);
    }

    public List<MPrivilege> getPrivilegesByPrincipal(MPrincipal principal, MResource resource) {
        return this.resourceRequests.readPrivilegesByPrincipal(principal, resource).getPrivileges();
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.resourceRequests.addDelegationTokens(renewer, credentials);
    }

    private Status applyLinkValidations(ValidationResultBean bean, MLink link) {
        ConfigValidationResult linkConfig = bean.getValidationResults()[0];
        ConfigUtils.applyValidation((List)link.getConnectorLinkConfig().getConfigs(), (ConfigValidationResult)linkConfig);
        Long id = bean.getId();
        if (id != null) {
            link.setPersistenceId(id.longValue());
        }
        return Status.getWorstStatus((Status[])new Status[]{linkConfig.getStatus()});
    }

    private Status applyJobValidations(ValidationResultBean bean, MJob job) {
        ConfigValidationResult fromConfig = bean.getValidationResults()[0];
        ConfigValidationResult toConfig = bean.getValidationResults()[1];
        ConfigValidationResult driver = bean.getValidationResults()[2];
        ConfigUtils.applyValidation((List)job.getFromJobConfig().getConfigs(), (ConfigValidationResult)fromConfig);
        ConfigUtils.applyValidation((List)job.getToJobConfig().getConfigs(), (ConfigValidationResult)toConfig);
        ConfigUtils.applyValidation((List)job.getDriverConfig().getConfigs(), (ConfigValidationResult)driver);
        Long id = bean.getId();
        if (id != null) {
            job.setPersistenceId(id.longValue());
        }
        return Status.getWorstStatus((Status[])new Status[]{fromConfig.getStatus(), toConfig.getStatus(), driver.getStatus()});
    }

    private static enum SubmissionStatus {
        SUBMITTED,
        UPDATED,
        FINISHED;

    }
}

