/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import org.apache.sqoop.client.request.ConnectionRequest;
import org.apache.sqoop.client.request.ConnectorRequest;
import org.apache.sqoop.client.request.FrameworkRequest;
import org.apache.sqoop.client.request.JobRequest;
import org.apache.sqoop.client.request.SubmissionRequest;
import org.apache.sqoop.json.ConnectionBean;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.FrameworkBean;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MJob;

public class SqoopRequests {
    private String serverUrl;
    private FrameworkRequest frameworkRequest;
    private ConnectorRequest connectorRequest;
    private ConnectionRequest connectionRequest;
    private JobRequest jobRequest;
    private SubmissionRequest submissionRequest;

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public FrameworkRequest getFrameworkRequest() {
        if (this.frameworkRequest == null) {
            this.frameworkRequest = new FrameworkRequest();
        }
        return this.frameworkRequest;
    }

    public ConnectorRequest getConnectorRequest() {
        if (this.connectorRequest == null) {
            this.connectorRequest = new ConnectorRequest();
        }
        return this.connectorRequest;
    }

    public ConnectionRequest getConnectionRequest() {
        if (this.connectionRequest == null) {
            this.connectionRequest = new ConnectionRequest();
        }
        return this.connectionRequest;
    }

    public JobRequest getJobRequest() {
        if (this.jobRequest == null) {
            this.jobRequest = new JobRequest();
        }
        return this.jobRequest;
    }

    public SubmissionRequest getSubmissionRequest() {
        if (this.submissionRequest == null) {
            this.submissionRequest = new SubmissionRequest();
        }
        return this.submissionRequest;
    }

    public FrameworkBean readFramework() {
        return this.getFrameworkRequest().read(this.serverUrl);
    }

    public ConnectorBean readConnector(Long cid) {
        return this.getConnectorRequest().read(this.serverUrl, cid);
    }

    public ValidationBean createConnection(MConnection connection) {
        return this.getConnectionRequest().create(this.serverUrl, connection);
    }

    public ConnectionBean readConnection(Long connectionId) {
        return this.getConnectionRequest().read(this.serverUrl, connectionId);
    }

    public ValidationBean updateConnection(MConnection connection) {
        return this.getConnectionRequest().update(this.serverUrl, connection);
    }

    public void enableConnection(Long xid, Boolean enabled) {
        this.getConnectionRequest().enable(this.serverUrl, xid, enabled);
    }

    public void deleteConnection(Long xid) {
        this.getConnectionRequest().delete(this.serverUrl, xid);
    }

    public ValidationBean createJob(MJob job) {
        return this.getJobRequest().create(this.serverUrl, job);
    }

    public JobBean readJob(Long jobId) {
        return this.getJobRequest().read(this.serverUrl, jobId);
    }

    public ValidationBean updateJob(MJob job) {
        return this.getJobRequest().update(this.serverUrl, job);
    }

    public void enableJob(Long jid, Boolean enabled) {
        this.getJobRequest().enable(this.serverUrl, jid, enabled);
    }

    public void deleteJob(Long jid) {
        this.getJobRequest().delete(this.serverUrl, jid);
    }

    public SubmissionBean readHistory(Long jid) {
        return this.getSubmissionRequest().readHistory(this.serverUrl, jid);
    }

    public SubmissionBean readSubmission(Long jid) {
        return this.getSubmissionRequest().read(this.serverUrl, jid);
    }

    public SubmissionBean createSubmission(Long jid) {
        return this.getSubmissionRequest().create(this.serverUrl, jid);
    }

    public SubmissionBean deleteSubmission(Long jid) {
        return this.getSubmissionRequest().delete(this.serverUrl, jid);
    }
}

