/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.client.request;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import org.apache.sqoop.client.ClientError;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.ThrowableBean;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Request {
    private static ServerExceptionFilter serverExceptionFilter = new ServerExceptionFilter();

    protected WebResource.Builder getBuilder(String url) {
        Client client = Client.create();
        WebResource resource = client.resource(url);
        resource.addFilter((ClientFilter)serverExceptionFilter);
        return (WebResource.Builder)((WebResource.Builder)resource.header("sqoop-user-name", (Object)System.getProperty("user.name")).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).acceptLanguage(new Locale[]{Locale.getDefault()});
    }

    public String get(String url) {
        return (String)this.getBuilder(url).get(String.class);
    }

    public String post(String url, String data) {
        return (String)this.getBuilder(url).post(String.class, (Object)data);
    }

    public String put(String url, String data) {
        return (String)this.getBuilder(url).put(String.class, (Object)data);
    }

    public String delete(String url) {
        return (String)this.getBuilder(url).delete(String.class);
    }

    private static class ServerExceptionFilter
    extends ClientFilter {
        private ServerExceptionFilter() {
        }

        public ClientResponse handle(ClientRequest cr) {
            ClientResponse resp = this.getNext().handle(cr);
            if (resp.getClientResponseStatus() == ClientResponse.Status.INTERNAL_SERVER_ERROR && resp.getHeaders().containsKey((Object)"sqoop-internal-error-code")) {
                ThrowableBean ex = new ThrowableBean();
                String responseText = (String)resp.getEntity(String.class);
                JSONObject json = (JSONObject)JSONValue.parse((String)responseText);
                ex.restore(json);
                throw new SqoopException((ErrorCode)ClientError.CLIENT_0001, ex.getThrowable());
            }
            return resp;
        }
    }
}

