/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.Partition;
import org.apache.sqoop.job.etl.Partitioner;
import org.apache.sqoop.job.etl.PartitionerContext;
import org.apache.sqoop.job.mr.ConfigurationUtils;
import org.apache.sqoop.job.mr.SqoopSplit;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopInputFormat
extends InputFormat<SqoopSplit, NullWritable> {
    public static final Logger LOG = Logger.getLogger(SqoopInputFormat.class);

    public RecordReader<SqoopSplit, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new SqoopRecordReader();
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String partitionerName = conf.get("org.apache.sqoop.job.etl.partitioner");
        Partitioner partitioner = (Partitioner)ClassUtils.instantiate((String)partitionerName, (Object[])new Object[0]);
        PrefixContext connectorContext = new PrefixContext(conf, "org.apache.sqoop.job.connector.context.");
        Object connectorConnection = ConfigurationUtils.getConfigConnectorConnection(conf);
        Object connectorJob = ConfigurationUtils.getConfigConnectorJob(conf);
        Schema schema = ConfigurationUtils.getConnectorSchema(conf);
        long maxPartitions = conf.getLong("org.apache.sqoop.job.etl.extractor.count", 10L);
        PartitionerContext partitionerContext = new PartitionerContext((ImmutableContext)connectorContext, maxPartitions, schema);
        List partitions = partitioner.getPartitions(partitionerContext, connectorConnection, connectorJob);
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        for (Partition partition : partitions) {
            LOG.debug((Object)("Partition: " + partition));
            SqoopSplit split = new SqoopSplit();
            split.setPartition(partition);
            splits.add(split);
        }
        if ((long)splits.size() > maxPartitions) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0025, String.format("Got %d, max was %d", splits.size(), maxPartitions));
        }
        return splits;
    }

    public static class SqoopRecordReader
    extends RecordReader<SqoopSplit, NullWritable> {
        private boolean delivered = false;
        private SqoopSplit split = null;

        public boolean nextKeyValue() {
            if (this.delivered) {
                return false;
            }
            this.delivered = true;
            return true;
        }

        public SqoopSplit getCurrentKey() {
            return this.split;
        }

        public NullWritable getCurrentValue() {
            return NullWritable.get();
        }

        public void close() {
        }

        public float getProgress() {
            return this.delivered ? 1.0f : 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
            this.split = (SqoopSplit)split;
        }
    }
}

