/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;
import org.apache.sqoop.job.io.Data;
import org.apache.sqoop.job.mr.SqoopDestroyerExecutor;
import org.apache.sqoop.job.mr.SqoopOutputFormatLoadExecutor;

public class SqoopFileOutputFormat
extends FileOutputFormat<Data, NullWritable> {
    public static final Logger LOG = Logger.getLogger(SqoopFileOutputFormat.class);
    public static final Class<? extends CompressionCodec> DEFAULT_CODEC = DefaultCodec.class;

    public RecordWriter<Data, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        Path filepath = this.getDefaultWorkFile(context, "");
        String filename = filepath.toString();
        conf.set("org.apache.sqoop.job.mr.output.file", filename);
        boolean isCompressed = SqoopFileOutputFormat.getCompressOutput((JobContext)context);
        if (isCompressed) {
            String codecname = conf.get("mapred.output.compression.codec", DEFAULT_CODEC.getName());
            conf.set("org.apache.sqoop.job.mr.output.codec", codecname);
        }
        SqoopOutputFormatLoadExecutor executor = new SqoopOutputFormatLoadExecutor((JobContext)context);
        return executor.getRecordWriter();
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        Path output = SqoopFileOutputFormat.getOutputPath((JobContext)context);
        return new DestroyerFileOutputCommitter(output, context);
    }

    public class DestroyerFileOutputCommitter
    extends FileOutputCommitter {
        public DestroyerFileOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
            super(outputPath, context);
        }

        public void commitJob(JobContext context) throws IOException {
            super.commitJob(context);
            Configuration config = context.getConfiguration();
            SqoopDestroyerExecutor.executeDestroyer(true, config, "org.apache.sqoop.job.etl.destroyer");
        }

        public void abortJob(JobContext context, JobStatus.State state) throws IOException {
            super.abortJob(context, state);
            Configuration config = context.getConfiguration();
            SqoopDestroyerExecutor.executeDestroyer(false, config, "org.apache.sqoop.job.etl.destroyer");
        }
    }
}

