/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sqoop.job.mr.SqoopMapper;
import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.model.FormUtils;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class ConfigurationUtils {
    private static final String JOB_TYPE = "org.apache.sqoop.job.type";
    private static final String JOB_CONFIG_CLASS_CONNECTOR_CONNECTION = "org.apache.sqoop.job.config.class.connector.connection";
    private static final String JOB_CONFIG_CLASS_CONNECTOR_JOB = "org.apache.sqoop.job.config.class.connector.job";
    private static final String JOB_CONFIG_CLASS_FRAMEWORK_CONNECTION = "org.apache.sqoop.job.config.class.framework.connection";
    private static final String JOB_CONFIG_CLASS_FRAMEWORK_JOB = "org.apache.sqoop.job.config.class.framework.job";
    private static final String JOB_CONFIG_CONNECTOR_CONNECTION = "org.apache.sqoop.job.config.connector.connection";
    private static final Text JOB_CONFIG_CONNECTOR_CONNECTION_KEY = new Text("org.apache.sqoop.job.config.connector.connection");
    private static final String JOB_CONFIG_CONNECTOR_JOB = "org.apache.sqoop.job.config.connector.job";
    private static final Text JOB_CONFIG_CONNECTOR_JOB_KEY = new Text("org.apache.sqoop.job.config.connector.job");
    private static final String JOB_CONFIG_FRAMEWORK_CONNECTION = "org.apache.sqoop.job.config.framework.connection";
    private static final Text JOB_CONFIG_FRAMEWORK_CONNECTION_KEY = new Text("org.apache.sqoop.job.config.framework.connection");
    private static final String JOB_CONFIG_FRAMEWORK_JOB = "org.apache.sqoop.job.config.framework.job";
    private static final Text JOB_CONFIG_FRAMEWORK_JOB_KEY = new Text("org.apache.sqoop.job.config.framework.job");
    private static final String SCHEMA_CONNECTOR = "org.apache.sqoop.job.schema.connector";
    private static final Text SCHEMA_CONNECTOR_KEY = new Text("org.apache.sqoop.job.schema.connector");
    private static final String SCHEMA_HIO = "org.apache.sqoop.job.schema.hio";
    private static final Text SCHEMA_HIO_KEY = new Text("org.apache.sqoop.job.schema.hio");

    public static void setJobType(Configuration configuration, MJob.Type type) {
        configuration.set(JOB_TYPE, type.name());
    }

    public static MJob.Type getJobType(Configuration configuration) {
        return MJob.Type.valueOf((String)configuration.get(JOB_TYPE));
    }

    public static void setConfigConnectorConnection(Job job, Object obj) {
        job.getConfiguration().set(JOB_CONFIG_CLASS_CONNECTOR_CONNECTION, obj.getClass().getName());
        job.getCredentials().addSecretKey(JOB_CONFIG_CONNECTOR_CONNECTION_KEY, FormUtils.toJson((Object)obj).getBytes());
    }

    public static void setConfigConnectorJob(Job job, Object obj) {
        job.getConfiguration().set(JOB_CONFIG_CLASS_CONNECTOR_JOB, obj.getClass().getName());
        job.getCredentials().addSecretKey(JOB_CONFIG_CONNECTOR_JOB_KEY, FormUtils.toJson((Object)obj).getBytes());
    }

    public static void setConfigFrameworkConnection(Job job, Object obj) {
        job.getConfiguration().set(JOB_CONFIG_CLASS_FRAMEWORK_CONNECTION, obj.getClass().getName());
        job.getCredentials().addSecretKey(JOB_CONFIG_FRAMEWORK_CONNECTION_KEY, FormUtils.toJson((Object)obj).getBytes());
    }

    public static void setConfigFrameworkJob(Job job, Object obj) {
        job.getConfiguration().set(JOB_CONFIG_CLASS_FRAMEWORK_JOB, obj.getClass().getName());
        job.getCredentials().addSecretKey(JOB_CONFIG_FRAMEWORK_JOB_KEY, FormUtils.toJson((Object)obj).getBytes());
    }

    public static Object getConfigConnectorConnection(Configuration configuration) {
        return ConfigurationUtils.loadConfiguration((JobConf)configuration, JOB_CONFIG_CLASS_CONNECTOR_CONNECTION, JOB_CONFIG_CONNECTOR_CONNECTION_KEY);
    }

    public static Object getConfigConnectorJob(Configuration configuration) {
        return ConfigurationUtils.loadConfiguration((JobConf)configuration, JOB_CONFIG_CLASS_CONNECTOR_JOB, JOB_CONFIG_CONNECTOR_JOB_KEY);
    }

    public static Object getConfigFrameworkConnection(Configuration configuration) {
        return ConfigurationUtils.loadConfiguration((JobConf)configuration, JOB_CONFIG_CLASS_FRAMEWORK_CONNECTION, JOB_CONFIG_FRAMEWORK_CONNECTION_KEY);
    }

    public static Object getConfigFrameworkJob(Configuration configuration) {
        return ConfigurationUtils.loadConfiguration((JobConf)configuration, JOB_CONFIG_CLASS_FRAMEWORK_JOB, JOB_CONFIG_FRAMEWORK_JOB_KEY);
    }

    public static void setConnectorSchema(Job job, Schema schema) {
        if (schema != null) {
            job.getCredentials().addSecretKey(SCHEMA_CONNECTOR_KEY, SchemaSerialization.extractSchema((Schema)schema).toJSONString().getBytes());
        }
    }

    public static void setHioSchema(Job job, Schema schema) {
        if (schema != null) {
            job.getCredentials().addSecretKey(SCHEMA_HIO_KEY, SchemaSerialization.extractSchema((Schema)schema).toJSONString().getBytes());
        }
    }

    public static Schema getConnectorSchema(Configuration configuration) {
        return ConfigurationUtils.getSchemaFromBytes(((JobConf)configuration).getCredentials().getSecretKey(SCHEMA_CONNECTOR_KEY));
    }

    public static Schema getHioSchema(Configuration configuration) {
        return ConfigurationUtils.getSchemaFromBytes(((JobConf)configuration).getCredentials().getSecretKey(SCHEMA_HIO_KEY));
    }

    private static Schema getSchemaFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return SchemaSerialization.restoreSchemna((JSONObject)((JSONObject)JSONValue.parse((String)new String(bytes))));
    }

    private static Object loadConfiguration(JobConf configuration, String classProperty, Text valueProperty) {
        Object object = ClassUtils.instantiate((String)configuration.get(classProperty), (Object[])new Object[0]);
        if (object == null) {
            return null;
        }
        String json = new String(configuration.getCredentials().getSecretKey(valueProperty));
        FormUtils.fillValues((String)json, (Object)object);
        return object;
    }

    private ConfigurationUtils() {
    }

    public static void configureLogging() {
        try {
            Properties props = new Properties();
            InputStream resourceAsStream = SqoopMapper.class.getResourceAsStream("/META-INF/log4j.properties");
            props.load(resourceAsStream);
            PropertyConfigurator.configure((Properties)props);
        }
        catch (Exception e) {
            System.err.println("Encountered exception while configuring logging for sqoop: " + e);
        }
    }
}

