/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.etl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.net.NodeBase;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.HdfsExportPartition;
import org.apache.sqoop.job.etl.Partition;
import org.apache.sqoop.job.etl.Partitioner;
import org.apache.sqoop.job.etl.PartitionerContext;

public class HdfsExportPartitioner
extends Partitioner {
    public static final String SPLIT_MINSIZE_PERNODE = "mapreduce.input.fileinputformat.split.minsize.per.node";
    public static final String SPLIT_MINSIZE_PERRACK = "mapreduce.input.fileinputformat.split.minsize.per.rack";
    private long maxSplitSize = 0L;
    private long minSplitSizeNode = 0L;
    private long minSplitSizeRack = 0L;
    private HashMap<String, Set<String>> rackToNodes = new HashMap();

    public List<Partition> getPartitions(PartitionerContext context, Object connectionConfiguration, Object jobConfiguration) {
        Configuration conf = ((PrefixContext)context.getContext()).getConfiguration();
        try {
            long numInputBytes = this.getInputSize(conf);
            this.maxSplitSize = numInputBytes / context.getMaxPartitions();
            if (numInputBytes % context.getMaxPartitions() != 0L) {
                ++this.maxSplitSize;
            }
            long minSizeNode = 0L;
            long minSizeRack = 0L;
            long maxSize = 0L;
            minSizeNode = this.minSplitSizeNode != 0L ? this.minSplitSizeNode : conf.getLong(SPLIT_MINSIZE_PERNODE, 0L);
            minSizeRack = this.minSplitSizeRack != 0L ? this.minSplitSizeRack : conf.getLong(SPLIT_MINSIZE_PERRACK, 0L);
            maxSize = this.maxSplitSize != 0L ? this.maxSplitSize : conf.getLong("mapreduce.input.fileinputformat.split.maxsize", 0L);
            if (minSizeNode != 0L && maxSize != 0L && minSizeNode > maxSize) {
                throw new IOException("Minimum split size pernode " + minSizeNode + " cannot be larger than maximum split size " + maxSize);
            }
            if (minSizeRack != 0L && maxSize != 0L && minSizeRack > maxSize) {
                throw new IOException("Minimum split size per rack" + minSizeRack + " cannot be larger than maximum split size " + maxSize);
            }
            if (minSizeRack != 0L && minSizeNode > minSizeRack) {
                throw new IOException("Minimum split size per node" + minSizeNode + " cannot be smaller than minimum split " + "size per rack " + minSizeRack);
            }
            String indir = conf.get("mapred.input.dir");
            FileSystem fs = FileSystem.get((Configuration)conf);
            LinkedList<Path> paths = new LinkedList<Path>();
            for (FileStatus status : fs.listStatus(new Path(indir))) {
                if (status.isDir()) continue;
                paths.add(status.getPath());
            }
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            if (paths.size() == 0) {
                return partitions;
            }
            this.getMoreSplits(conf, paths, maxSize, minSizeNode, minSizeRack, partitions);
            this.rackToNodes.clear();
            return partitions;
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0021, (Throwable)e);
        }
    }

    private long getInputSize(Configuration conf) throws IOException {
        String indir = conf.get("mapred.input.dir");
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] files = fs.listStatus(new Path(indir));
        long count = 0L;
        for (FileStatus file : files) {
            count += file.getLen();
        }
        return count;
    }

    private void getMoreSplits(Configuration conf, List<Path> paths, long maxSize, long minSizeNode, long minSizeRack, List<Partition> partitions) throws IOException {
        HashMap<String, List<OneBlockInfo>> rackToBlocks = new HashMap<String, List<OneBlockInfo>>();
        HashMap<OneBlockInfo, String[]> blockToNodes = new HashMap<OneBlockInfo, String[]>();
        HashMap<String, List<OneBlockInfo>> nodeToBlocks = new HashMap<String, List<OneBlockInfo>>();
        OneFileInfo[] files = new OneFileInfo[paths.size()];
        if (paths.size() == 0) {
            return;
        }
        for (int i = 0; i < paths.size(); ++i) {
            files[i] = new OneFileInfo(paths.get(i), conf, this.isSplitable(conf, paths.get(i)), rackToBlocks, blockToNodes, nodeToBlocks, this.rackToNodes, maxSize);
        }
        ArrayList<OneBlockInfo> validBlocks = new ArrayList<OneBlockInfo>();
        HashSet<String> nodes = new HashSet<String>();
        long curSplitSize = 0L;
        for (Map.Entry one : nodeToBlocks.entrySet()) {
            nodes.add((String)one.getKey());
            List blocksInNode = (List)one.getValue();
            for (OneBlockInfo oneblock : blocksInNode) {
                if (!blockToNodes.containsKey(oneblock)) continue;
                validBlocks.add(oneblock);
                blockToNodes.remove(oneblock);
                if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                this.addCreatedSplit(partitions, nodes, validBlocks);
                curSplitSize = 0L;
                validBlocks.clear();
            }
            if (minSizeNode != 0L && curSplitSize >= minSizeNode) {
                this.addCreatedSplit(partitions, nodes, validBlocks);
            } else {
                for (OneBlockInfo oneblock : validBlocks) {
                    blockToNodes.put(oneblock, oneblock.hosts);
                }
            }
            validBlocks.clear();
            nodes.clear();
            curSplitSize = 0L;
        }
        ArrayList<OneBlockInfo> overflowBlocks = new ArrayList<OneBlockInfo>();
        HashSet<String> racks = new HashSet<String>();
        while (blockToNodes.size() > 0) {
            for (Map.Entry<String, List<OneBlockInfo>> one : rackToBlocks.entrySet()) {
                racks.add(one.getKey());
                List<OneBlockInfo> blocks = one.getValue();
                boolean createdSplit = false;
                for (OneBlockInfo oneblock : blocks) {
                    if (!blockToNodes.containsKey(oneblock)) continue;
                    validBlocks.add(oneblock);
                    blockToNodes.remove(oneblock);
                    if (maxSize == 0L || (curSplitSize += oneblock.length) < maxSize) continue;
                    this.addCreatedSplit(partitions, this.getHosts(racks), validBlocks);
                    createdSplit = true;
                    break;
                }
                if (createdSplit) {
                    curSplitSize = 0L;
                    validBlocks.clear();
                    racks.clear();
                    continue;
                }
                if (!validBlocks.isEmpty()) {
                    if (minSizeRack != 0L && curSplitSize >= minSizeRack) {
                        this.addCreatedSplit(partitions, this.getHosts(racks), validBlocks);
                    } else {
                        overflowBlocks.addAll(validBlocks);
                    }
                }
                curSplitSize = 0L;
                validBlocks.clear();
                racks.clear();
            }
        }
        assert (blockToNodes.isEmpty());
        assert (curSplitSize == 0L);
        assert (validBlocks.isEmpty());
        assert (racks.isEmpty());
        for (OneBlockInfo oneblock : overflowBlocks) {
            validBlocks.add(oneblock);
            curSplitSize += oneblock.length;
            for (int i = 0; i < oneblock.racks.length; ++i) {
                racks.add(oneblock.racks[i]);
            }
            if (maxSize == 0L || curSplitSize < maxSize) continue;
            this.addCreatedSplit(partitions, this.getHosts(racks), validBlocks);
            curSplitSize = 0L;
            validBlocks.clear();
            racks.clear();
        }
        if (!validBlocks.isEmpty()) {
            this.addCreatedSplit(partitions, this.getHosts(racks), validBlocks);
        }
    }

    private boolean isSplitable(Configuration conf, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(file);
        return null == codec;
    }

    private void addCreatedSplit(List<Partition> partitions, Collection<String> locations, ArrayList<OneBlockInfo> validBlocks) {
        Path[] files = new Path[validBlocks.size()];
        long[] offsets = new long[validBlocks.size()];
        long[] lengths = new long[validBlocks.size()];
        for (int i = 0; i < validBlocks.size(); ++i) {
            files[i] = validBlocks.get((int)i).onepath;
            offsets[i] = validBlocks.get((int)i).offset;
            lengths[i] = validBlocks.get((int)i).length;
        }
        HdfsExportPartition partition = new HdfsExportPartition(files, offsets, lengths, locations.toArray(new String[0]));
        partitions.add(partition);
    }

    private Set<String> getHosts(Set<String> racks) {
        HashSet<String> hosts = new HashSet<String>();
        for (String rack : racks) {
            if (!this.rackToNodes.containsKey(rack)) continue;
            hosts.addAll((Collection<String>)this.rackToNodes.get(rack));
        }
        return hosts;
    }

    private static void addHostToRack(HashMap<String, Set<String>> rackToNodes, String rack, String host) {
        Set<String> hosts = rackToNodes.get(rack);
        if (hosts == null) {
            hosts = new HashSet<String>();
            rackToNodes.put(rack, hosts);
        }
        hosts.add(host);
    }

    private static class OneBlockInfo {
        Path onepath;
        long offset;
        long length;
        String[] hosts;
        String[] racks;

        OneBlockInfo(Path path, long offset, long len, String[] hosts, String[] topologyPaths) {
            int i;
            this.onepath = path;
            this.offset = offset;
            this.hosts = hosts;
            this.length = len;
            assert (hosts.length == topologyPaths.length || topologyPaths.length == 0);
            if (topologyPaths.length == 0) {
                topologyPaths = new String[hosts.length];
                for (i = 0; i < topologyPaths.length; ++i) {
                    topologyPaths[i] = new NodeBase(hosts[i], "/default-rack").toString();
                }
            }
            this.racks = new String[topologyPaths.length];
            for (i = 0; i < topologyPaths.length; ++i) {
                this.racks[i] = new NodeBase(topologyPaths[i]).getNetworkLocation();
            }
        }
    }

    private static class OneFileInfo {
        private long fileSize = 0L;
        private OneBlockInfo[] blocks;

        OneFileInfo(Path path, Configuration conf, boolean isSplitable, HashMap<String, List<OneBlockInfo>> rackToBlocks, HashMap<OneBlockInfo, String[]> blockToNodes, HashMap<String, List<OneBlockInfo>> nodeToBlocks, HashMap<String, Set<String>> rackToNodes, long maxSize) throws IOException {
            FileSystem fs = path.getFileSystem(conf);
            FileStatus stat = fs.getFileStatus(path);
            BlockLocation[] locations = fs.getFileBlockLocations(stat, 0L, stat.getLen());
            if (locations == null) {
                this.blocks = new OneBlockInfo[0];
            } else {
                if (!isSplitable) {
                    this.blocks = new OneBlockInfo[1];
                    this.fileSize = stat.getLen();
                    this.blocks[0] = new OneBlockInfo(path, 0L, this.fileSize, locations[0].getHosts(), locations[0].getTopologyPaths());
                } else {
                    ArrayList<OneBlockInfo> blocksList = new ArrayList<OneBlockInfo>(locations.length);
                    for (int i = 0; i < locations.length; ++i) {
                        this.fileSize += locations[i].getLength();
                        long left = locations[i].getLength();
                        long myOffset = locations[i].getOffset();
                        long myLength = 0L;
                        do {
                            myLength = maxSize == 0L ? left : (left > maxSize && left < 2L * maxSize ? left / 2L : Math.min(maxSize, left));
                            OneBlockInfo oneblock = new OneBlockInfo(path, myOffset, myLength, locations[i].getHosts(), locations[i].getTopologyPaths());
                            myOffset += myLength;
                            blocksList.add(oneblock);
                        } while ((left -= myLength) > 0L);
                    }
                    this.blocks = blocksList.toArray(new OneBlockInfo[blocksList.size()]);
                }
                for (OneBlockInfo oneblock : this.blocks) {
                    List<OneBlockInfo> blklist;
                    int j;
                    blockToNodes.put(oneblock, oneblock.hosts);
                    String[] racks = null;
                    racks = oneblock.hosts.length == 0 ? new String[]{"/default-rack"} : oneblock.racks;
                    for (j = 0; j < racks.length; ++j) {
                        String rack = racks[j];
                        blklist = rackToBlocks.get(rack);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            rackToBlocks.put(rack, blklist);
                        }
                        blklist.add(oneblock);
                        if (racks[j].equals("/default-rack")) continue;
                        HdfsExportPartitioner.addHostToRack(rackToNodes, racks[j], oneblock.hosts[j]);
                    }
                    for (j = 0; j < oneblock.hosts.length; ++j) {
                        String node = oneblock.hosts[j];
                        blklist = nodeToBlocks.get(node);
                        if (blklist == null) {
                            blklist = new ArrayList<OneBlockInfo>();
                            nodeToBlocks.put(node, blklist);
                        }
                        blklist.add(oneblock);
                    }
                }
            }
        }
    }
}

