/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.execution.mapreduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.io.NullWritable;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MutableMapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.execution.mapreduce.MRSubmissionRequest;
import org.apache.sqoop.framework.ExecutionEngine;
import org.apache.sqoop.framework.SubmissionRequest;
import org.apache.sqoop.framework.configuration.ExportJobConfiguration;
import org.apache.sqoop.framework.configuration.ImportJobConfiguration;
import org.apache.sqoop.framework.configuration.OutputFormat;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.etl.Exporter;
import org.apache.sqoop.job.etl.HdfsExportExtractor;
import org.apache.sqoop.job.etl.HdfsExportPartitioner;
import org.apache.sqoop.job.etl.HdfsSequenceImportLoader;
import org.apache.sqoop.job.etl.HdfsTextImportLoader;
import org.apache.sqoop.job.etl.Importer;
import org.apache.sqoop.job.io.Data;
import org.apache.sqoop.job.mr.SqoopFileOutputFormat;
import org.apache.sqoop.job.mr.SqoopInputFormat;
import org.apache.sqoop.job.mr.SqoopMapper;
import org.apache.sqoop.job.mr.SqoopNullOutputFormat;

public class MapreduceExecutionEngine
extends ExecutionEngine {
    public SubmissionRequest createSubmissionRequest() {
        return new MRSubmissionRequest();
    }

    public void prepareImportSubmission(SubmissionRequest gRequest) {
        MRSubmissionRequest request = (MRSubmissionRequest)gRequest;
        ImportJobConfiguration jobConf = (ImportJobConfiguration)request.getConfigFrameworkJob();
        this.addDependencies(request);
        request.setInputFormatClass(SqoopInputFormat.class);
        request.setMapperClass(SqoopMapper.class);
        request.setMapOutputKeyClass(Data.class);
        request.setMapOutputValueClass(NullWritable.class);
        request.setOutputFormatClass(SqoopFileOutputFormat.class);
        request.setOutputKeyClass(Data.class);
        request.setOutputValueClass(NullWritable.class);
        Importer importer = (Importer)request.getConnectorCallbacks();
        MutableMapContext context = request.getFrameworkContext();
        context.setString("org.apache.sqoop.job.etl.partitioner", importer.getPartitioner().getName());
        context.setString("org.apache.sqoop.job.etl.extractor", importer.getExtractor().getName());
        context.setString("org.apache.sqoop.job.etl.destroyer", importer.getDestroyer().getName());
        if (request.getExtractors() != null) {
            context.setInteger("org.apache.sqoop.job.etl.extractor.count", request.getExtractors().intValue());
        }
        if (jobConf.output.outputFormat == OutputFormat.TEXT_FILE) {
            context.setString("org.apache.sqoop.job.etl.loader", HdfsTextImportLoader.class.getName());
        } else if (jobConf.output.outputFormat == OutputFormat.SEQUENCE_FILE) {
            context.setString("org.apache.sqoop.job.etl.loader", HdfsSequenceImportLoader.class.getName());
        } else {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0024, "Format: " + jobConf.output.outputFormat);
        }
        if (this.getCompressionCodecName(jobConf) != null) {
            context.setString("mapred.output.compression.codec", this.getCompressionCodecName(jobConf));
            context.setBoolean("mapred.output.compress", true);
        }
    }

    private String getCompressionCodecName(ImportJobConfiguration jobConf) {
        if (jobConf.output.compression == null) {
            return null;
        }
        switch (jobConf.output.compression) {
            case NONE: {
                return null;
            }
            case DEFAULT: {
                return "org.apache.hadoop.io.compress.DefaultCodec";
            }
            case DEFLATE: {
                return "org.apache.hadoop.io.compress.DeflateCodec";
            }
            case GZIP: {
                return "org.apache.hadoop.io.compress.GzipCodec";
            }
            case BZIP2: {
                return "org.apache.hadoop.io.compress.BZip2Codec";
            }
            case LZO: {
                return "com.hadoop.compression.lzo.LzoCodec";
            }
            case LZ4: {
                return "org.apache.hadoop.io.compress.Lz4Codec";
            }
            case SNAPPY: {
                return "org.apache.hadoop.io.compress.SnappyCodec";
            }
            case CUSTOM: {
                return jobConf.output.customCompression.trim();
            }
        }
        return null;
    }

    public void prepareExportSubmission(SubmissionRequest gRequest) {
        MRSubmissionRequest request = (MRSubmissionRequest)gRequest;
        ExportJobConfiguration jobConf = (ExportJobConfiguration)request.getConfigFrameworkJob();
        this.addDependencies(request);
        request.setInputFormatClass(SqoopInputFormat.class);
        request.setMapperClass(SqoopMapper.class);
        request.setMapOutputKeyClass(Data.class);
        request.setMapOutputValueClass(NullWritable.class);
        request.setOutputFormatClass(SqoopNullOutputFormat.class);
        request.setOutputKeyClass(Data.class);
        request.setOutputValueClass(NullWritable.class);
        Exporter exporter = (Exporter)request.getConnectorCallbacks();
        MutableMapContext context = request.getFrameworkContext();
        context.setString("org.apache.sqoop.job.etl.partitioner", HdfsExportPartitioner.class.getName());
        context.setString("org.apache.sqoop.job.etl.loader", exporter.getLoader().getName());
        context.setString("org.apache.sqoop.job.etl.destroyer", exporter.getDestroyer().getName());
        context.setString("org.apache.sqoop.job.etl.extractor", HdfsExportExtractor.class.getName());
        context.setString("mapred.input.dir", jobConf.input.inputDirectory);
        if (request.getExtractors() != null) {
            context.setInteger("org.apache.sqoop.job.etl.extractor.count", request.getExtractors().intValue());
        }
    }

    protected void addDependencies(MRSubmissionRequest request) {
        request.addJarForClass(ThreadFactoryBuilder.class);
    }
}

