/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.etl.io.DataReader;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.Loader;
import org.apache.sqoop.job.etl.LoaderContext;
import org.apache.sqoop.job.io.Data;
import org.apache.sqoop.job.mr.ConfigurationUtils;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopOutputFormatLoadExecutor {
    public static final Logger LOG = Logger.getLogger(SqoopOutputFormatLoadExecutor.class);
    private volatile boolean readerFinished = false;
    private volatile boolean writerFinished = false;
    private volatile Data data;
    private JobContext context;
    private SqoopRecordWriter producer;
    private Future<?> consumerFuture;
    private Semaphore filled = new Semaphore(0, true);
    private Semaphore free = new Semaphore(1, true);
    private volatile boolean isTest = false;
    private String loaderName;

    SqoopOutputFormatLoadExecutor(boolean isTest, String loaderName) {
        this.isTest = isTest;
        this.loaderName = loaderName;
        this.data = new Data();
        this.producer = new SqoopRecordWriter();
    }

    public SqoopOutputFormatLoadExecutor(JobContext jobctx) {
        this.data = new Data();
        this.context = jobctx;
        this.producer = new SqoopRecordWriter();
    }

    public RecordWriter<Data, NullWritable> getRecordWriter() {
        this.consumerFuture = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("OutputFormatLoader-consumer").build()).submit(new ConsumerThread());
        return this.producer;
    }

    private void checkIfConsumerThrew() {
        if (this.readerFinished) {
            this.waitForConsumer();
        }
    }

    private void waitForConsumer() {
        try {
            this.consumerFuture.get();
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (t instanceof SqoopException) {
                throw (SqoopException)t;
            }
            Throwables.propagate((Throwable)t);
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0019, (Throwable)ex);
        }
    }

    private class ConsumerThread
    implements Runnable {
        private ConsumerThread() {
        }

        @Override
        public void run() {
            LOG.info((Object)"SqoopOutputFormatLoadExecutor consumer thread is starting");
            try {
                OutputFormatDataReader reader = new OutputFormatDataReader();
                Configuration conf = null;
                if (!SqoopOutputFormatLoadExecutor.this.isTest) {
                    conf = SqoopOutputFormatLoadExecutor.this.context.getConfiguration();
                    SqoopOutputFormatLoadExecutor.this.loaderName = conf.get("org.apache.sqoop.job.etl.loader");
                }
                Loader loader = (Loader)ClassUtils.instantiate((String)SqoopOutputFormatLoadExecutor.this.loaderName, (Object[])new Object[0]);
                PrefixContext subContext = null;
                Object configConnection = null;
                Object configJob = null;
                Schema schema = null;
                if (!SqoopOutputFormatLoadExecutor.this.isTest) {
                    schema = ConfigurationUtils.getConnectorSchema(conf);
                    switch (ConfigurationUtils.getJobType(conf)) {
                        case EXPORT: {
                            subContext = new PrefixContext(conf, "org.apache.sqoop.job.connector.context.");
                            configConnection = ConfigurationUtils.getConfigConnectorConnection(conf);
                            configJob = ConfigurationUtils.getConfigConnectorJob(conf);
                            break;
                        }
                        case IMPORT: {
                            subContext = new PrefixContext(conf, "");
                            configConnection = ConfigurationUtils.getConfigFrameworkConnection(conf);
                            configJob = ConfigurationUtils.getConfigFrameworkJob(conf);
                            break;
                        }
                        default: {
                            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0023);
                        }
                    }
                }
                LoaderContext loaderContext = new LoaderContext(subContext, (DataReader)reader, schema);
                LOG.info((Object)("Running loader class " + SqoopOutputFormatLoadExecutor.this.loaderName));
                loader.load(loaderContext, configConnection, configJob);
                LOG.info((Object)"Loader has finished");
            }
            catch (Throwable t) {
                SqoopOutputFormatLoadExecutor.this.readerFinished = true;
                LOG.error((Object)"Error while loading data out of MR job.", t);
                SqoopOutputFormatLoadExecutor.this.free.release();
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0018, t);
            }
            if (!SqoopOutputFormatLoadExecutor.this.writerFinished) {
                SqoopOutputFormatLoadExecutor.this.readerFinished = true;
                LOG.error((Object)"Reader terminated, but writer is still running!");
                SqoopOutputFormatLoadExecutor.this.free.release();
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0019);
            }
            SqoopOutputFormatLoadExecutor.this.readerFinished = true;
        }
    }

    private class OutputFormatDataReader
    extends DataReader {
        private OutputFormatDataReader() {
        }

        public void setFieldDelimiter(char fieldDelimiter) {
            SqoopOutputFormatLoadExecutor.this.data.setFieldDelimiter(fieldDelimiter);
        }

        public Object[] readArrayRecord() throws InterruptedException {
            return (Object[])this.readContent(2);
        }

        public String readCsvRecord() throws InterruptedException {
            return (String)this.readContent(1);
        }

        public Object readContent(int type) throws InterruptedException {
            try {
                SqoopOutputFormatLoadExecutor.this.filled.acquire();
            }
            catch (InterruptedException ex) {
                LOG.error((Object)"Interrupted while waiting for data to be available from mapper", (Throwable)ex);
                throw ex;
            }
            if (SqoopOutputFormatLoadExecutor.this.writerFinished) {
                return null;
            }
            try {
                Object content;
                Object object = content = SqoopOutputFormatLoadExecutor.this.data.getContent(type);
                return object;
            }
            catch (Throwable t) {
                SqoopOutputFormatLoadExecutor.this.readerFinished = true;
                LOG.error((Object)"Caught exception e while getting content ", t);
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0018, t);
            }
            finally {
                SqoopOutputFormatLoadExecutor.this.free.release();
            }
        }
    }

    private class SqoopRecordWriter
    extends RecordWriter<Data, NullWritable> {
        private SqoopRecordWriter() {
        }

        public void write(Data key, NullWritable value) throws InterruptedException {
            SqoopOutputFormatLoadExecutor.this.free.acquire();
            SqoopOutputFormatLoadExecutor.this.checkIfConsumerThrew();
            int type = key.getType();
            SqoopOutputFormatLoadExecutor.this.data.setContent(key.getContent(type), type);
            SqoopOutputFormatLoadExecutor.this.filled.release();
        }

        public void close(TaskAttemptContext context) throws InterruptedException, IOException {
            LOG.info((Object)"SqoopOutputFormatLoadExecutor::SqoopRecordWriter is about to be closed");
            SqoopOutputFormatLoadExecutor.this.free.acquire();
            SqoopOutputFormatLoadExecutor.this.writerFinished = true;
            SqoopOutputFormatLoadExecutor.this.filled.release();
            SqoopOutputFormatLoadExecutor.this.waitForConsumer();
            LOG.info((Object)"SqoopOutputFormatLoadExecutor::SqoopRecordWriter is closed");
        }
    }
}

