/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.job.io.Data;
import org.apache.sqoop.job.mr.SqoopDestroyerExecutor;
import org.apache.sqoop.job.mr.SqoopOutputFormatLoadExecutor;

public class SqoopNullOutputFormat
extends OutputFormat<Data, NullWritable> {
    public static final Logger LOG = Logger.getLogger(SqoopNullOutputFormat.class);

    public void checkOutputSpecs(JobContext context) {
    }

    public RecordWriter<Data, NullWritable> getRecordWriter(TaskAttemptContext context) {
        SqoopOutputFormatLoadExecutor executor = new SqoopOutputFormatLoadExecutor((JobContext)context);
        return executor.getRecordWriter();
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new DestroyerOutputCommitter();
    }

    class DestroyerOutputCommitter
    extends OutputCommitter {
        DestroyerOutputCommitter() {
        }

        public void setupJob(JobContext jobContext) {
        }

        public void commitJob(JobContext jobContext) throws IOException {
            super.commitJob(jobContext);
            Configuration config = jobContext.getConfiguration();
            SqoopDestroyerExecutor.executeDestroyer(true, config, "org.apache.sqoop.job.etl.destroyer");
        }

        public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
            super.abortJob(jobContext, state);
            Configuration config = jobContext.getConfiguration();
            SqoopDestroyerExecutor.executeDestroyer(false, config, "org.apache.sqoop.job.etl.destroyer");
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }
    }
}

