/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.Destroyer;
import org.apache.sqoop.job.etl.DestroyerContext;
import org.apache.sqoop.job.mr.ConfigurationUtils;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopDestroyerExecutor {
    public static final Logger LOG = Logger.getLogger(SqoopDestroyerExecutor.class);

    public static void executeDestroyer(boolean success, Configuration configuration, String propertyName) {
        Destroyer destroyer = (Destroyer)ClassUtils.instantiate((String)configuration.get(propertyName), (Object[])new Object[0]);
        if (destroyer == null) {
            LOG.info((Object)"Skipping running destroyer as non was defined.");
            return;
        }
        PrefixContext subContext = new PrefixContext(configuration, "org.apache.sqoop.job.connector.context.");
        Object configConnection = ConfigurationUtils.getConfigConnectorConnection(configuration);
        Object configJob = ConfigurationUtils.getConfigConnectorJob(configuration);
        Schema schema = ConfigurationUtils.getConnectorSchema(configuration);
        DestroyerContext destroyerContext = new DestroyerContext((ImmutableContext)subContext, success, schema);
        LOG.info((Object)("Executing destroyer class " + destroyer.getClass()));
        destroyer.destroy(destroyerContext, configConnection, configJob);
    }

    private SqoopDestroyerExecutor() {
    }
}

