/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.etl;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.etl.io.DataReader;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.etl.Loader;
import org.apache.sqoop.job.etl.LoaderContext;
import org.apache.sqoop.utils.ClassUtils;

public class HdfsSequenceImportLoader
extends Loader {
    public static final String EXTENSION = ".seq";
    private final char fieldDelimiter = (char)44;

    public void load(LoaderContext context, Object oc, Object oj) throws Exception {
        DataReader reader = context.getDataReader();
        reader.setFieldDelimiter(this.fieldDelimiter);
        Configuration conf = new Configuration();
        String filename = context.getString("org.apache.sqoop.job.mr.output.file");
        String codecname = context.getString("org.apache.sqoop.job.mr.output.codec");
        CompressionCodec codec = null;
        if (codecname != null) {
            Class clz = ClassUtils.loadClass((String)codecname);
            if (clz == null) {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0009, codecname);
            }
            try {
                codec = (CompressionCodec)clz.newInstance();
                if (codec instanceof Configurable) {
                    ((Configurable)codec).setConf(conf);
                }
            }
            catch (Exception e) {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0010, codecname, (Throwable)e);
            }
        }
        filename = filename + EXTENSION;
        try {
            String csv;
            Path filepath = new Path(filename);
            SequenceFile.Writer filewriter = codec != null ? SequenceFile.createWriter((FileSystem)filepath.getFileSystem(conf), (Configuration)conf, (Path)filepath, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec) : SequenceFile.createWriter((FileSystem)filepath.getFileSystem(conf), (Configuration)conf, (Path)filepath, Text.class, NullWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            Text text = new Text();
            while ((csv = reader.readCsvRecord()) != null) {
                text.set(csv);
                filewriter.append((Writable)text, (Writable)NullWritable.get());
            }
            filewriter.close();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0018, (Throwable)e);
        }
    }
}

