/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.etl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.LineReader;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.etl.io.DataWriter;
import org.apache.sqoop.framework.configuration.ConnectionConfiguration;
import org.apache.sqoop.framework.configuration.ExportJobConfiguration;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.Extractor;
import org.apache.sqoop.job.etl.ExtractorContext;
import org.apache.sqoop.job.etl.HdfsExportPartition;

public class HdfsExportExtractor
extends Extractor<ConnectionConfiguration, ExportJobConfiguration, HdfsExportPartition> {
    public static final Logger LOG = Logger.getLogger(HdfsExportExtractor.class);
    private Configuration conf;
    private DataWriter dataWriter;
    private long rowRead = 0L;
    private final char fieldDelimiter = (char)44;

    public void extract(ExtractorContext context, ConnectionConfiguration connectionConfiguration, ExportJobConfiguration jobConfiguration, HdfsExportPartition partition) {
        this.conf = ((PrefixContext)context.getContext()).getConfiguration();
        this.dataWriter = context.getDataWriter();
        this.dataWriter.setFieldDelimiter(this.fieldDelimiter);
        try {
            HdfsExportPartition p = partition;
            LOG.info((Object)("Working on partition: " + (Object)((Object)p)));
            int numFiles = p.getNumberOfFiles();
            for (int i = 0; i < numFiles; ++i) {
                this.extractFile(p.getFile(i), p.getOffset(i), p.getLength(i));
            }
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0017, (Throwable)e);
        }
    }

    private void extractFile(Path file, long start, long length) throws IOException {
        long end = start + length;
        LOG.info((Object)("Extracting file " + file));
        LOG.info((Object)("\t from offset " + start));
        LOG.info((Object)("\t to offset " + end));
        LOG.info((Object)("\t of length " + length));
        if (this.isSequenceFile(file)) {
            this.extractSequenceFile(file, start, length);
        } else {
            this.extractTextFile(file, start, length);
        }
    }

    private void extractSequenceFile(Path file, long start, long length) throws IOException {
        LOG.info((Object)"Extracting sequence file");
        long end = start + length;
        SequenceFile.Reader filereader = new SequenceFile.Reader(file.getFileSystem(this.conf), file, this.conf);
        if (start > filereader.getPosition()) {
            filereader.sync(start);
        }
        Text line = new Text();
        boolean hasNext = filereader.next((Writable)line);
        while (hasNext) {
            ++this.rowRead;
            this.dataWriter.writeCsvRecord(line.toString());
            line = new Text();
            hasNext = filereader.next((Writable)line);
            if (filereader.getPosition() < end || !filereader.syncSeen()) continue;
        }
        filereader.close();
    }

    private void extractTextFile(Path file, long start, long length) throws IOException {
        Text line;
        int size;
        LineReader filereader;
        LOG.info((Object)"Extracting text file");
        long end = start + length;
        FileSystem fs = file.getFileSystem(this.conf);
        FSDataInputStream filestream = fs.open(file);
        CompressionCodec codec = new CompressionCodecFactory(this.conf).getCodec(file);
        FSDataInputStream fileseeker = filestream;
        if (codec == null) {
            filestream.seek(start);
            filereader = new LineReader((InputStream)filestream);
        } else {
            filereader = new LineReader((InputStream)codec.createInputStream((InputStream)filestream, codec.createDecompressor()), this.conf);
            fileseeker = filestream;
        }
        if (start != 0L) {
            start += (long)filereader.readLine(new Text(), 0);
        }
        LOG.info((Object)("Start position: " + String.valueOf(start)));
        long next = start;
        while (next <= end && (size = filereader.readLine(line = new Text(), Integer.MAX_VALUE)) != 0) {
            next = codec == null ? (next += (long)size) : fileseeker.getPos();
            ++this.rowRead;
            this.dataWriter.writeCsvRecord(line.toString());
        }
        LOG.info((Object)("Extracting ended on position: " + fileseeker.getPos()));
        filestream.close();
    }

    public long getRowsRead() {
        return this.rowRead;
    }

    private boolean isSequenceFile(Path file) {
        SequenceFile.Reader filereader = null;
        try {
            filereader = new SequenceFile.Reader(file.getFileSystem(this.conf), file, this.conf);
            filereader.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

