/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.etl.Partition;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopSplit
extends InputSplit
implements Writable {
    private Partition partition;

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public long getLength() throws IOException {
        return 0L;
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    public void readFields(DataInput in) throws IOException {
        String className = in.readUTF();
        Class clz = ClassUtils.loadClass((String)className);
        if (clz == null) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0009, className);
        }
        try {
            this.partition = (Partition)clz.newInstance();
        }
        catch (Exception e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0010, className, (Throwable)e);
        }
        this.partition.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.partition.getClass().getName());
        this.partition.write(out);
    }
}

