/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.mr;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.etl.io.DataWriter;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.PrefixContext;
import org.apache.sqoop.job.etl.Extractor;
import org.apache.sqoop.job.etl.ExtractorContext;
import org.apache.sqoop.job.io.Data;
import org.apache.sqoop.job.mr.ConfigurationUtils;
import org.apache.sqoop.job.mr.ProgressRunnable;
import org.apache.sqoop.job.mr.SqoopSplit;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.counter.SqoopCounters;
import org.apache.sqoop.utils.ClassUtils;

public class SqoopMapper
extends Mapper<SqoopSplit, NullWritable, Data, NullWritable> {
    public static final Logger LOG;
    private final ScheduledExecutorService progressService = Executors.newSingleThreadScheduledExecutor();

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String extractorName = conf.get("org.apache.sqoop.job.etl.extractor");
        Extractor extractor = (Extractor)ClassUtils.instantiate((String)extractorName, (Object[])new Object[0]);
        PrefixContext subContext = null;
        Object configConnection = null;
        Object configJob = null;
        Schema schema = ConfigurationUtils.getConnectorSchema(conf);
        switch (ConfigurationUtils.getJobType(conf)) {
            case IMPORT: {
                subContext = new PrefixContext(conf, "org.apache.sqoop.job.connector.context.");
                configConnection = ConfigurationUtils.getConfigConnectorConnection(conf);
                configJob = ConfigurationUtils.getConfigConnectorJob(conf);
                break;
            }
            case EXPORT: {
                subContext = new PrefixContext(conf, "");
                configConnection = ConfigurationUtils.getConfigFrameworkConnection(conf);
                configJob = ConfigurationUtils.getConfigFrameworkJob(conf);
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0023);
            }
        }
        SqoopSplit split = (SqoopSplit)((Object)context.getCurrentKey());
        ExtractorContext extractorContext = new ExtractorContext((ImmutableContext)subContext, (DataWriter)new MapDataWriter(context), schema);
        try {
            LOG.info((Object)"Starting progress service");
            this.progressService.scheduleAtFixedRate(new ProgressRunnable((TaskInputOutputContext)context), 0L, 2L, TimeUnit.MINUTES);
            LOG.info((Object)("Running extractor class " + extractorName));
            extractor.extract(extractorContext, configConnection, configJob, (Object)split.getPartition());
            LOG.info((Object)"Extractor has finished");
            context.getCounter((Enum)SqoopCounters.ROWS_READ).increment(extractor.getRowsRead());
        }
        catch (Exception e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0017, (Throwable)e);
        }
        finally {
            LOG.info((Object)"Stopping progress service");
            this.progressService.shutdown();
            if (!this.progressService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.info((Object)"Stopping progress service with shutdownNow");
                this.progressService.shutdownNow();
            }
        }
    }

    static {
        ConfigurationUtils.configureLogging();
        LOG = Logger.getLogger(SqoopMapper.class);
    }

    public class MapDataWriter
    extends DataWriter {
        private Mapper.Context context;
        private Data data;

        public MapDataWriter(Mapper.Context context) {
            this.context = context;
        }

        public void setFieldDelimiter(char fieldDelimiter) {
            if (this.data == null) {
                this.data = new Data();
            }
            this.data.setFieldDelimiter(fieldDelimiter);
        }

        public void writeArrayRecord(Object[] array) {
            this.writeContent(array, 2);
        }

        public void writeCsvRecord(String csv) {
            this.writeContent(csv, 1);
        }

        public void writeContent(Object content, int type) {
            if (this.data == null) {
                this.data = new Data();
            }
            this.data.setContent(content, type);
            try {
                this.context.write((Object)this.data, (Object)NullWritable.get());
            }
            catch (Exception e) {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0013, (Throwable)e);
            }
        }
    }
}

