/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.job.MapreduceExecutionError;

public class Data
implements WritableComparable<Data> {
    private volatile Object content = null;
    public static final int EMPTY_DATA = 0;
    public static final int CSV_RECORD = 1;
    public static final int ARRAY_RECORD = 2;
    private int type = 0;
    public static final String CHARSET_NAME = "UTF-8";
    public static final char DEFAULT_RECORD_DELIMITER = '\n';
    public static final char DEFAULT_FIELD_DELIMITER = ',';
    public static final char DEFAULT_STRING_DELIMITER = '\'';
    public static final char DEFAULT_STRING_ESCAPE = '\\';
    private char fieldDelimiter = (char)44;
    private char stringDelimiter = (char)39;
    private char stringEscape = (char)92;
    private String escapedStringDelimiter = String.valueOf(new char[]{this.stringEscape, this.stringDelimiter});
    private int[] fieldTypes = null;

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setFieldTypes(int[] fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public void setContent(Object content, int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                this.type = type;
                this.content = content;
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(type));
            }
        }
    }

    public Object getContent(int targetType) {
        switch (targetType) {
            case 1: {
                return this.format();
            }
            case 2: {
                return this.parse();
            }
        }
        throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(targetType));
    }

    public int getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.type == 0;
    }

    public String toString() {
        return (String)this.getContent(1);
    }

    public int compareTo(Data other) {
        byte[] myBytes = this.toString().getBytes(Charset.forName(CHARSET_NAME));
        byte[] otherBytes = other.toString().getBytes(Charset.forName(CHARSET_NAME));
        return WritableComparator.compareBytes((byte[])myBytes, (int)0, (int)myBytes.length, (byte[])otherBytes, (int)0, (int)otherBytes.length);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Data)) {
            return false;
        }
        Data data = (Data)other;
        if (this.type != data.getType()) {
            return false;
        }
        return this.toString().equals(data.toString());
    }

    public int hashCode() {
        int result = super.hashCode();
        switch (this.type) {
            case 1: {
                return result += 31 * this.content.hashCode();
            }
            case 2: {
                Object[] array = (Object[])this.content;
                for (int i = 0; i < array.length; ++i) {
                    result += 31 * array[i].hashCode();
                }
                return result;
            }
        }
        throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(this.type));
    }

    public void readFields(DataInput in) throws IOException {
        this.type = this.readType(in);
        switch (this.type) {
            case 1: {
                this.readCsv(in);
                break;
            }
            case 2: {
                this.readArray(in);
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(this.type));
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        this.writeType(out, this.type);
        switch (this.type) {
            case 1: {
                this.writeCsv(out);
                break;
            }
            case 2: {
                this.writeArray(out);
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(this.type));
            }
        }
    }

    private int readType(DataInput in) throws IOException {
        return WritableUtils.readVInt((DataInput)in);
    }

    private void writeType(DataOutput out, int type) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)type);
    }

    private void readCsv(DataInput in) throws IOException {
        this.content = in.readUTF();
    }

    private void writeCsv(DataOutput out) throws IOException {
        out.writeUTF((String)this.content);
    }

    private void readArray(DataInput in) throws IOException {
        int columns = in.readInt();
        this.content = new Object[columns];
        Object[] array = (Object[])this.content;
        block13: for (int i = 0; i < array.length; ++i) {
            int type = this.readType(in);
            switch (type) {
                case 101: {
                    array[i] = in.readUTF();
                    continue block13;
                }
                case 100: {
                    int length = in.readInt();
                    byte[] bytes = new byte[length];
                    in.readFully(bytes);
                    array[i] = bytes;
                    continue block13;
                }
                case 51: {
                    array[i] = in.readDouble();
                    continue block13;
                }
                case 50: {
                    array[i] = Float.valueOf(in.readFloat());
                    continue block13;
                }
                case 22: {
                    array[i] = in.readLong();
                    continue block13;
                }
                case 21: {
                    array[i] = in.readInt();
                    continue block13;
                }
                case 20: {
                    array[i] = in.readShort();
                    continue block13;
                }
                case 11: {
                    array[i] = Character.valueOf(in.readChar());
                    continue block13;
                }
                case 10: {
                    array[i] = in.readByte();
                    continue block13;
                }
                case 1: {
                    array[i] = in.readBoolean();
                    continue block13;
                }
                case 0: {
                    array[i] = null;
                    continue block13;
                }
                default: {
                    throw new IOException((Throwable)new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, Integer.toString(type)));
                }
            }
        }
    }

    private void writeArray(DataOutput out) throws IOException {
        Object[] array = (Object[])this.content;
        out.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof String) {
                this.writeType(out, 101);
                out.writeUTF((String)array[i]);
                continue;
            }
            if (array[i] instanceof byte[]) {
                this.writeType(out, 100);
                out.writeInt(((byte[])array[i]).length);
                out.write((byte[])array[i]);
                continue;
            }
            if (array[i] instanceof Double) {
                this.writeType(out, 51);
                out.writeDouble((Double)array[i]);
                continue;
            }
            if (array[i] instanceof Float) {
                this.writeType(out, 50);
                out.writeFloat(((Float)array[i]).floatValue());
                continue;
            }
            if (array[i] instanceof Long) {
                this.writeType(out, 22);
                out.writeLong((Long)array[i]);
                continue;
            }
            if (array[i] instanceof Integer) {
                this.writeType(out, 21);
                out.writeInt((Integer)array[i]);
                continue;
            }
            if (array[i] instanceof Short) {
                this.writeType(out, 20);
                out.writeShort(((Short)array[i]).shortValue());
                continue;
            }
            if (array[i] instanceof Character) {
                this.writeType(out, 11);
                out.writeChar(((Character)array[i]).charValue());
                continue;
            }
            if (array[i] instanceof Byte) {
                this.writeType(out, 10);
                out.writeByte(((Byte)array[i]).byteValue());
                continue;
            }
            if (array[i] instanceof Boolean) {
                this.writeType(out, 1);
                out.writeBoolean((Boolean)array[i]);
                continue;
            }
            if (array[i] == null) {
                this.writeType(out, 0);
                continue;
            }
            throw new IOException((Throwable)new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, array[i].getClass().getName()));
        }
    }

    private String format() {
        switch (this.type) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.fieldDelimiter == ',') {
                    return (String)this.content;
                }
                return ((String)this.content).replaceAll(String.valueOf(','), String.valueOf(this.fieldDelimiter));
            }
            case 2: {
                StringBuilder sb = new StringBuilder();
                Object[] array = (Object[])this.content;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        sb.append(this.fieldDelimiter);
                    }
                    if (array[i] instanceof String) {
                        sb.append(this.stringDelimiter);
                        sb.append(this.escape((String)array[i]));
                        sb.append(this.stringDelimiter);
                        continue;
                    }
                    if (array[i] instanceof byte[]) {
                        sb.append(Arrays.toString((byte[])array[i]));
                        continue;
                    }
                    sb.append(String.valueOf(array[i]));
                }
                return sb.toString();
            }
        }
        throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(this.type));
    }

    private Object[] parse() {
        switch (this.type) {
            case 0: {
                return null;
            }
            case 1: {
                int start;
                int position;
                ArrayList<Object> list = new ArrayList<Object>();
                char[] record = ((String)this.content).toCharArray();
                boolean stringDelimited = false;
                boolean arrayDelimited = false;
                int index = 0;
                for (position = start = 0; position < record.length; ++position) {
                    if (record[position] == this.fieldDelimiter) {
                        if (stringDelimited || arrayDelimited) continue;
                        index = this.parseField(list, record, start, position, index);
                        start = position + 1;
                        continue;
                    }
                    if (record[position] == this.stringDelimiter) {
                        if (!stringDelimited) {
                            stringDelimited = true;
                            continue;
                        }
                        if (position <= 0 || record[position - 1] == this.stringEscape) continue;
                        stringDelimited = false;
                        continue;
                    }
                    if (record[position] == '[') {
                        if (stringDelimited) continue;
                        arrayDelimited = true;
                        continue;
                    }
                    if (record[position] != ']' || stringDelimited) continue;
                    arrayDelimited = false;
                }
                this.parseField(list, record, start, position, index);
                return list.toArray();
            }
            case 2: {
                return (Object[])this.content;
            }
        }
        throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(this.type));
    }

    private int parseField(ArrayList<Object> list, char[] record, int start, int end, int index) {
        String field = String.valueOf(record, start, end - start).trim();
        int fieldType = this.fieldTypes == null ? this.guessType(field) : this.fieldTypes[index];
        switch (fieldType) {
            case 101: {
                if (field.charAt(0) != this.stringDelimiter || field.charAt(field.length() - 1) != this.stringDelimiter) {
                    throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0022);
                }
                list.add(index, this.unescape(field.substring(1, field.length() - 1)));
                break;
            }
            case 100: {
                if (field.charAt(0) != '[' || field.charAt(field.length() - 1) != ']') {
                    throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0022);
                }
                String[] splits = field.substring(1, field.length() - 1).split(String.valueOf(','));
                byte[] bytes = new byte[splits.length];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = Byte.parseByte(splits[i].trim());
                }
                list.add(index, bytes);
                break;
            }
            case 51: {
                list.add(index, Double.parseDouble(field));
                break;
            }
            case 50: {
                list.add(index, Float.valueOf(Float.parseFloat(field)));
                break;
            }
            case 22: {
                list.add(index, Long.parseLong(field));
                break;
            }
            case 21: {
                list.add(index, Integer.parseInt(field));
                break;
            }
            case 20: {
                list.add(index, Short.parseShort(field));
                break;
            }
            case 11: {
                list.add(index, Character.valueOf(field.charAt(0)));
                break;
            }
            case 10: {
                list.add(index, Byte.parseByte(field));
                break;
            }
            case 1: {
                list.add(index, Boolean.parseBoolean(field));
                break;
            }
            case 0: {
                list.add(index, null);
                break;
            }
            default: {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0012, String.valueOf(fieldType));
            }
        }
        return ++index;
    }

    private int guessType(String field) {
        char[] value = field.toCharArray();
        if (value[0] == this.stringDelimiter) {
            return 101;
        }
        switch (value[0]) {
            case 'N': 
            case 'n': {
                return 0;
            }
            case '[': {
                return 100;
            }
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return 1;
            }
        }
        int position = 1;
        while (position < value.length) {
            switch (value[position++]) {
                case '.': {
                    return 51;
                }
            }
        }
        return 22;
    }

    private String escape(String string) {
        String regex = String.valueOf(this.stringDelimiter);
        String replacement = Matcher.quoteReplacement(this.escapedStringDelimiter);
        return string.replaceAll(regex, replacement);
    }

    private String unescape(String string) {
        String regex = Matcher.quoteReplacement(this.escapedStringDelimiter);
        String replacement = String.valueOf(this.stringDelimiter);
        return string.replaceAll(regex, replacement);
    }
}

