/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.etl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.etl.io.DataReader;
import org.apache.sqoop.job.MapreduceExecutionError;
import org.apache.sqoop.job.etl.Loader;
import org.apache.sqoop.job.etl.LoaderContext;
import org.apache.sqoop.utils.ClassUtils;

public class HdfsTextImportLoader
extends Loader {
    private final char fieldDelimiter = (char)44;
    private final char recordDelimiter = (char)10;

    public void load(LoaderContext context, Object oc, Object oj) throws Exception {
        DataReader reader = context.getDataReader();
        reader.setFieldDelimiter(this.fieldDelimiter);
        Configuration conf = new Configuration();
        String filename = context.getString("org.apache.sqoop.job.mr.output.file");
        String codecname = context.getString("org.apache.sqoop.job.mr.output.codec");
        CompressionCodec codec = null;
        if (codecname != null) {
            Class clz = ClassUtils.loadClass((String)codecname);
            if (clz == null) {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0009, codecname);
            }
            try {
                codec = (CompressionCodec)clz.newInstance();
                if (codec instanceof Configurable) {
                    ((Configurable)codec).setConf(conf);
                }
            }
            catch (Exception e) {
                throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0010, codecname, (Throwable)e);
            }
            filename = filename + codec.getDefaultExtension();
        }
        try {
            String csv;
            Path filepath = new Path(filename);
            FileSystem fs = filepath.getFileSystem(conf);
            FSDataOutputStream filestream = fs.create(filepath, false);
            BufferedWriter filewriter = codec != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)filestream, codec.createCompressor()), "UTF-8")) : new BufferedWriter(new OutputStreamWriter((OutputStream)filestream, "UTF-8"));
            while ((csv = reader.readCsvRecord()) != null) {
                filewriter.write(csv + this.recordDelimiter);
            }
            filewriter.close();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceExecutionError.MAPRED_EXEC_0018, (Throwable)e);
        }
    }
}

