/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.job.etl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.job.etl.Partition;

public class HdfsExportPartition
extends Partition {
    private long lenFiles;
    private int numFiles;
    private Path[] files;
    private long[] offsets;
    private long[] lengths;
    private String[] locations;

    public HdfsExportPartition() {
    }

    public HdfsExportPartition(Path[] files, long[] offsets, long[] lengths, String[] locations) {
        for (long length : lengths) {
            this.lenFiles += length;
        }
        this.numFiles = files.length;
        this.files = files;
        this.offsets = offsets;
        this.lengths = lengths;
        this.locations = locations;
    }

    public long getLengthOfFiles() {
        return this.lenFiles;
    }

    public int getNumberOfFiles() {
        return this.numFiles;
    }

    public Path getFile(int i) {
        return this.files[i];
    }

    public long getOffset(int i) {
        return this.offsets[i];
    }

    public long getLength(int i) {
        return this.lengths[i];
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        this.numFiles = in.readInt();
        this.files = new Path[this.numFiles];
        for (i = 0; i < this.numFiles; ++i) {
            this.files[i] = new Path(in.readUTF());
        }
        this.offsets = new long[this.numFiles];
        for (i = 0; i < this.numFiles; ++i) {
            this.offsets[i] = in.readLong();
        }
        this.lengths = new long[this.numFiles];
        for (i = 0; i < this.numFiles; ++i) {
            this.lengths[i] = in.readLong();
        }
        for (long length : this.lengths) {
            this.lenFiles += length;
        }
        int numLocations = in.readInt();
        if (numLocations == 0) {
            this.locations = null;
        } else {
            this.locations = new String[numLocations];
            for (int i2 = 0; i2 < numLocations; ++i2) {
                this.locations[i2] = in.readUTF();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numFiles);
        for (Path path : this.files) {
            out.writeUTF(path.toString());
        }
        for (long l : this.offsets) {
            out.writeLong(l);
        }
        for (long l : this.lengths) {
            out.writeLong(l);
        }
        if (this.locations == null || this.locations.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.locations.length);
            for (String string : this.locations) {
                out.writeUTF(string);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (int i = 0; i < this.files.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.files[i]);
            sb.append(" (offset=").append(this.offsets[i]);
            sb.append(", end=").append(this.offsets[i] + this.lengths[i]);
            sb.append(", length=").append(this.lengths[i]);
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }
}

