/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.sentry.SentryIndexAuthorizationSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDocAuthorizationComponent
extends SearchComponent {
    private static Logger log = LoggerFactory.getLogger(QueryDocAuthorizationComponent.class);
    public static String AUTH_FIELD_PROP = "sentryAuthField";
    public static String DEFAULT_AUTH_FIELD = "sentry_auth";
    public static String ALL_ROLES_TOKEN_PROP = "allRolesToken";
    public static String ENABLED_PROP = "enabled";
    private SentryIndexAuthorizationSingleton sentryInstance;
    private String authField;
    private String allRolesToken;
    private boolean enabled;

    public QueryDocAuthorizationComponent() {
        this(SentryIndexAuthorizationSingleton.getInstance());
    }

    @VisibleForTesting
    public QueryDocAuthorizationComponent(SentryIndexAuthorizationSingleton sentryInstance) {
        this.sentryInstance = sentryInstance;
    }

    public void init(NamedList args) {
        SolrParams params = SolrParams.toSolrParams((NamedList)args);
        this.authField = params.get(AUTH_FIELD_PROP, DEFAULT_AUTH_FIELD);
        log.info("QueryDocAuthorizationComponent authField: " + this.authField);
        this.allRolesToken = params.get(ALL_ROLES_TOKEN_PROP, "");
        log.info("QueryDocAuthorizationComponent allRolesToken: " + this.allRolesToken);
        this.enabled = params.getBool(ENABLED_PROP, false);
        log.info("QueryDocAuthorizationComponent enabled: " + this.enabled);
    }

    private void addRawClause(StringBuilder builder, String authField, String value) {
        builder.append(" {!raw f=").append(authField).append(" v=").append(value).append("}");
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        StringBuilder builder;
        if (!this.enabled) {
            return;
        }
        String userName = this.sentryInstance.getUserName(rb.req);
        String superUser = System.getProperty("solr.authorization.superuser", "solr");
        if (superUser.equals(userName)) {
            return;
        }
        Set<String> roles = this.sentryInstance.getRoles(userName);
        if (roles != null && roles.size() > 0) {
            builder = new StringBuilder();
            for (String role : roles) {
                this.addRawClause(builder, this.authField, role);
            }
            if (this.allRolesToken != null && !this.allRolesToken.isEmpty()) {
                this.addRawClause(builder, this.authField, this.allRolesToken);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Request from user: " + userName + " rejected because user is not associated with any roles");
        }
        ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
        String result = builder.toString();
        newParams.add("fq", new String[]{result});
        rb.req.setParams((SolrParams)newParams);
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Document Authorization";
    }

    public String getSource() {
        return "$URL$";
    }
}

