/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.SecureRequestHandlerUtil;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class SecureCoreAdminHandler
extends CoreAdminHandler {
    public SecureCoreAdminHandler() {
    }

    public SecureCoreAdminHandler(CoreContainer coreContainer) {
        super(coreContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCollectionFromCoreName(String coreName) {
        SolrCore solrCore = null;
        try {
            if (coreName != null && !coreName.equals("") && (solrCore = this.coreContainer.getCore(coreName)) != null) {
                String string = solrCore.getCoreDescriptor().getCloudDescriptor().getCollectionName();
                return string;
            }
        }
        finally {
            if (solrCore != null) {
                solrCore.close();
            }
        }
        return null;
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get((String)a)) == null) {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_AND_UPDATE, "CoreAdminAction." + a, true, null);
        }
        String collection = null;
        boolean checkCollection = true;
        if (action != null) {
            switch (action) {
                case RENAME: 
                case UNLOAD: 
                case RELOAD: 
                case SWAP: 
                case MERGEINDEXES: 
                case SPLIT: 
                case PREPRECOVERY: 
                case REQUESTRECOVERY: 
                case REQUESTSYNCSHARD: {
                    String cname = params.get("core", "");
                    collection = this.getCollectionFromCoreName(cname);
                    break;
                }
                case CREATE: {
                    CoreDescriptor coreDescriptor = SecureCoreAdminHandler.buildCoreDescriptor((SolrParams)params, (CoreContainer)this.coreContainer);
                    if (coreDescriptor == null) break;
                    collection = coreDescriptor.getCloudDescriptor().getCollectionName();
                    break;
                }
                case REQUESTAPPLYUPDATES: 
                case REQUESTBUFFERUPDATES: {
                    String cname = params.get("name", "");
                    collection = this.getCollectionFromCoreName(cname);
                    break;
                }
                default: {
                    checkCollection = false;
                }
            }
            switch (action) {
                case STATUS: 
                case REQUESTSTATUS: {
                    SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, "CoreAdminAction." + action.toString(), checkCollection, collection);
                    break;
                }
                case RENAME: 
                case UNLOAD: 
                case RELOAD: 
                case SWAP: 
                case MERGEINDEXES: 
                case SPLIT: 
                case PREPRECOVERY: 
                case REQUESTRECOVERY: 
                case REQUESTSYNCSHARD: 
                case CREATE: 
                case REQUESTAPPLYUPDATES: 
                case REQUESTBUFFERUPDATES: 
                case PERSIST: 
                case CREATEALIAS: 
                case DELETEALIAS: 
                case LOAD: 
                case LOAD_ON_STARTUP: 
                case TRANSIENT: 
                case OVERSEEROP: {
                    SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.UPDATE_ONLY, "CoreAdminAction." + action.toString(), checkCollection, collection);
                    break;
                }
                default: {
                    SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_AND_UPDATE, "CoreAdminAction." + action.toString(), checkCollection, collection);
                }
            }
        }
        super.handleRequestBody(req, rsp);
    }
}

