/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.SecureRequestHandlerUtil;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class SecureCollectionsHandler
extends CollectionsHandler {
    public SecureCollectionsHandler() {
    }

    public SecureCollectionsHandler(CoreContainer coreContainer) {
        super(coreContainer);
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        CollectionParams.CollectionAction action = null;
        String a = params.get("action");
        String collection = null;
        if (a != null) {
            action = CollectionParams.CollectionAction.get((String)a);
        }
        if (action != null) {
            switch (action) {
                case CREATE: 
                case DELETE: 
                case RELOAD: 
                case CREATEALIAS: 
                case DELETEALIAS: {
                    collection = req.getParams().required().get("name");
                    break;
                }
                case SYNCSHARD: 
                case SPLITSHARD: 
                case DELETESHARD: {
                    collection = req.getParams().required().get("collection");
                    break;
                }
                default: {
                    collection = null;
                }
            }
        }
        SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.UPDATE_ONLY, action != null ? "CollectionAction." + action.toString() : ((Object)((Object)this)).getClass().getName() + "/" + a, true, collection);
        super.handleRequestBody(req, rsp);
        if (action.equals((Object)CollectionParams.CollectionAction.DELETE)) {
            SecureRequestHandlerUtil.syncDeleteCollection(collection);
        }
    }
}

