/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.SecureRequestHandlerUtil;
import org.apache.solr.handler.admin.AdminHandlers;
import org.apache.solr.handler.admin.LoggingHandler;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.admin.PluginInfoHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.admin.SolrInfoMBeanHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.zookeeper.KeeperException;

public class SecureAdminHandlers
extends AdminHandlers {
    public void inform(SolrCore core) {
        StandardHandler[] list;
        String path = null;
        for (Map.Entry entry : core.getRequestHandlers().entrySet()) {
            if (entry.getValue() != this) continue;
            path = (String)entry.getKey();
            break;
        }
        if (path == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The AdminHandler is not registered with the current core.");
        }
        if (!path.startsWith("/")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The AdminHandler needs to be registered to a path.  Typically this is '/admin'");
        }
        core.registerRequestHandler(path, null);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        for (StandardHandler handler : list = new StandardHandler[]{new StandardHandler("luke", (SolrRequestHandler)new SecureLukeRequestHandler()), new StandardHandler("system", (SolrRequestHandler)new SecureSystemInfoHandler()), new StandardHandler("mbeans", (SolrRequestHandler)new SecureSolrInfoMBeanHandler()), new StandardHandler("plugins", (SolrRequestHandler)new SecurePluginInfoHandler()), new StandardHandler("threads", (SolrRequestHandler)new SecureThreadDumpHandler()), new StandardHandler("properties", (SolrRequestHandler)new SecurePropertiesRequestHandler()), new StandardHandler("logging", (SolrRequestHandler)new SecureLoggingHandler()), new StandardHandler("file", (SolrRequestHandler)new SecureShowFileRequestHandler())}) {
            if (core.getRequestHandler(path + handler.name) != null) continue;
            handler.handler.init(this.initArgs);
            core.registerRequestHandler(path + handler.name, handler.handler);
            if (!(handler.handler instanceof SolrCoreAware)) continue;
            ((SolrCoreAware)handler.handler).inform(core);
        }
    }

    public static class SecureThreadDumpHandler
    extends ThreadDumpHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), false, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecureSystemInfoHandler
    extends SystemInfoHandler {
        public SecureSystemInfoHandler() {
        }

        public SecureSystemInfoHandler(CoreContainer cc) {
            super(cc);
        }

        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            SolrCore core = req.getCore();
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), core != null, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecureSolrInfoMBeanHandler
    extends SolrInfoMBeanHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), true, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecureShowFileRequestHandler
    extends ShowFileRequestHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, KeeperException, InterruptedException {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), true, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecurePropertiesRequestHandler
    extends PropertiesRequestHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), false, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecurePluginInfoHandler
    extends PluginInfoHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), true, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecureLukeRequestHandler
    extends LukeRequestHandler {
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_ONLY, ((Object)((Object)this)).getClass().getName(), true, null);
            super.handleRequestBody(req, rsp);
        }
    }

    public static class SecureLoggingHandler
    extends LoggingHandler {
        public SecureLoggingHandler(CoreContainer cc) {
            super(cc);
        }

        public SecureLoggingHandler() {
        }

        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            SecureRequestHandlerUtil.checkSentryAdmin(req, SecureRequestHandlerUtil.QUERY_AND_UPDATE, ((Object)((Object)this)).getClass().getName(), false, null);
            super.handleRequestBody(req, rsp);
        }
    }

    protected static class StandardHandler {
        final String name;
        final SolrRequestHandler handler;

        public StandardHandler(String n, SolrRequestHandler h) {
            this.name = n;
            this.handler = h;
        }
    }
}

