/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sentry.core.model.search.SearchModelAction;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.sentry.SentryIndexAuthorizationSingleton;

public class SecureRequestHandlerUtil {
    public static final Set<SearchModelAction> QUERY_ONLY = EnumSet.of(SearchModelAction.QUERY);
    public static final Set<SearchModelAction> UPDATE_ONLY = EnumSet.of(SearchModelAction.UPDATE);
    public static final Set<SearchModelAction> QUERY_AND_UPDATE = EnumSet.of(SearchModelAction.QUERY, SearchModelAction.UPDATE);
    public static SentryIndexAuthorizationSingleton testOverride = null;

    public static void checkSentryAdmin(SolrQueryRequest req, Set<SearchModelAction> andActions, String operation, boolean checkCollection, String collection) {
        SecureRequestHandlerUtil.checkSentry(req, andActions, operation, true, checkCollection, collection);
    }

    public static void checkSentryCollection(SolrQueryRequest req, Set<SearchModelAction> andActions, String operation) {
        SecureRequestHandlerUtil.checkSentry(req, andActions, operation, false, false, null);
    }

    public static void syncDeleteCollection(String collection) {
        SentryIndexAuthorizationSingleton sentryInstance = testOverride == null ? SentryIndexAuthorizationSingleton.getInstance() : testOverride;
        sentryInstance.deleteCollection(collection);
    }

    private static void checkSentry(SolrQueryRequest req, Set<SearchModelAction> andActions, String operation, boolean admin, boolean checkCollection, String collection) {
        SentryIndexAuthorizationSingleton sentryInstance = testOverride == null ? SentryIndexAuthorizationSingleton.getInstance() : testOverride;
        for (SearchModelAction action : andActions) {
            if (admin) {
                sentryInstance.authorizeAdminAction(req, EnumSet.of(action), operation, checkCollection, collection);
                continue;
            }
            sentryInstance.authorizeCollectionAction(req, EnumSet.of(action), operation);
        }
    }
}

