/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.file;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.policy.common.PrivilegeUtils;
import org.apache.sentry.policy.common.PrivilegeValidator;
import org.apache.sentry.policy.common.PrivilegeValidatorContext;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.file.PolicyFileConstants;
import org.apache.sentry.provider.file.PolicyFiles;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileProviderBackend
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFileProviderBackend.class);
    private final FileSystem fileSystem;
    private final Path resourcePath;
    private final Configuration conf;
    private final List<String> configErrors;
    private final List<String> configWarnings;
    private final Table<String, String, Set<String>> groupRolePrivilegeTable;
    private final Interner<String> stringInterner;
    private ImmutableList<PrivilegeValidator> validators;
    private boolean allowPerDatabaseSection;
    private volatile boolean initialized;

    public SimpleFileProviderBackend(Configuration conf, String resourcePath) throws IOException {
        this(conf, new Path(resourcePath));
    }

    public SimpleFileProviderBackend(Configuration conf, Path resourcePath) throws IOException {
        this.resourcePath = resourcePath;
        this.fileSystem = resourcePath.getFileSystem(conf);
        this.groupRolePrivilegeTable = HashBasedTable.create();
        this.conf = conf;
        this.configErrors = Lists.newArrayList();
        this.configWarnings = Lists.newArrayList();
        this.validators = ImmutableList.of();
        this.allowPerDatabaseSection = true;
        this.initialized = false;
        this.stringInterner = Interners.newWeakInterner();
    }

    public void initialize(ProviderBackendContext context) {
        if (this.initialized) {
            throw new IllegalStateException("Backend has already been initialized, cannot be initialized twice");
        }
        this.validators = context.getValidators();
        this.allowPerDatabaseSection = context.isAllowPerDatabase();
        this.parse();
        this.initialized = true;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String groupName : groups) {
            for (Map.Entry row : this.groupRolePrivilegeTable.row((Object)groupName).entrySet()) {
                if (!roleSet.containsRole((String)row.getKey())) continue;
                resultBuilder.addAll((Iterable)row.getValue());
            }
        }
        return resultBuilder.build();
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        if (groups != null) {
            for (String groupName : groups) {
                for (Map.Entry row : this.groupRolePrivilegeTable.row((Object)groupName).entrySet()) {
                    if (!roleSet.containsRole((String)row.getKey())) continue;
                    resultBuilder.add(row.getKey());
                }
            }
        }
        return resultBuilder.build();
    }

    public void close() {
        this.groupRolePrivilegeTable.clear();
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        ArrayList localConfigErrors = Lists.newArrayList(this.configErrors);
        ArrayList localConfigWarnings = Lists.newArrayList(this.configWarnings);
        if (strictValidation && !localConfigWarnings.isEmpty() || !localConfigErrors.isEmpty()) {
            localConfigErrors.add("Failed to process global policy file " + this.resourcePath);
            SentryConfigurationException e = new SentryConfigurationException("");
            e.setConfigErrors((List)localConfigErrors);
            e.setConfigWarnings((List)localConfigWarnings);
            throw e;
        }
    }

    private void parse() {
        this.configErrors.clear();
        this.configWarnings.clear();
        HashBasedTable groupRolePrivilegeTableTemp = HashBasedTable.create();
        LOGGER.info("Parsing " + this.resourcePath);
        LOGGER.info("Filesystem: " + this.fileSystem.getUri());
        try {
            Ini ini;
            try {
                ini = PolicyFiles.loadFromPath(this.fileSystem, this.resourcePath);
            }
            catch (IOException e) {
                this.configErrors.add("Failed to read policy file " + this.resourcePath + " Error: " + e.getMessage());
                throw new SentryConfigurationException("Error loading policy file " + this.resourcePath, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.configErrors.add("Failed to read policy file " + this.resourcePath + " Error: " + e.getMessage());
                throw new SentryConfigurationException("Error loading policy file " + this.resourcePath, (Throwable)e);
            }
            if (LOGGER.isDebugEnabled()) {
                for (String sectionName : ini.getSectionNames()) {
                    LOGGER.debug("Section: " + sectionName);
                    Ini.Section section = ini.get((Object)sectionName);
                    for (String key : section.keySet()) {
                        String value = section.get((Object)key);
                        LOGGER.debug(key + " = " + value);
                    }
                }
            }
            this.parseIni(null, ini, (List<? extends PrivilegeValidator>)this.validators, this.resourcePath, (Table<String, String, Set<String>>)groupRolePrivilegeTableTemp);
            this.mergeResult((Table<String, String, Set<String>>)groupRolePrivilegeTableTemp);
            groupRolePrivilegeTableTemp.clear();
            Ini.Section filesSection = ini.getSection("databases");
            if (filesSection == null) {
                LOGGER.info("Section databases needs no further processing");
            } else {
                if (!this.allowPerDatabaseSection) {
                    String msg = "Per-db policy file is not expected in this configuration.";
                    throw new SentryConfigurationException(msg);
                }
                for (Map.Entry entry : filesSection.entrySet()) {
                    String database = Strings.nullToEmpty((String)((String)entry.getKey())).trim().toLowerCase();
                    Path perDbPolicy = new Path(Strings.nullToEmpty((String)((String)entry.getValue())).trim());
                    if (this.isRelative(perDbPolicy)) {
                        perDbPolicy = new Path(this.resourcePath.getParent(), perDbPolicy);
                    }
                    try {
                        LOGGER.debug("Parsing " + perDbPolicy);
                        Ini perDbIni = PolicyFiles.loadFromPath(perDbPolicy.getFileSystem(this.conf), perDbPolicy);
                        if (perDbIni.containsKey((Object)"users")) {
                            this.configErrors.add("Per-db policy file cannot contain users section in " + perDbPolicy);
                            throw new SentryConfigurationException("Per-db policy files cannot contain users section");
                        }
                        if (perDbIni.containsKey((Object)"databases")) {
                            this.configErrors.add("Per-db policy files cannot contain databases section in " + perDbPolicy);
                            throw new SentryConfigurationException("Per-db policy files cannot contain databases section");
                        }
                        this.parseIni(database, perDbIni, (List<? extends PrivilegeValidator>)this.validators, perDbPolicy, (Table<String, String, Set<String>>)groupRolePrivilegeTableTemp);
                    }
                    catch (Exception e) {
                        this.configErrors.add("Failed to read per-DB policy file " + perDbPolicy + " Error: " + e.getMessage());
                        LOGGER.error("Error processing key " + (String)entry.getKey() + ", skipping " + (String)entry.getValue(), (Throwable)e);
                    }
                }
            }
            this.mergeResult((Table<String, String, Set<String>>)groupRolePrivilegeTableTemp);
            groupRolePrivilegeTableTemp.clear();
        }
        catch (Exception e) {
            this.configErrors.add("Error processing file " + this.resourcePath + e.getMessage());
            LOGGER.error("Error processing file, ignoring " + this.resourcePath, (Throwable)e);
        }
    }

    private boolean isRelative(Path path) {
        URI uri = path.toUri();
        return uri.getAuthority() == null && uri.getScheme() == null && !path.isUriPathAbsolute();
    }

    private void mergeResult(Table<String, String, Set<String>> groupRolePrivilegeTableTemp) {
        for (Table.Cell cell : groupRolePrivilegeTableTemp.cellSet()) {
            String roleName;
            String groupName = (String)cell.getRowKey();
            HashSet privileges = (HashSet)this.groupRolePrivilegeTable.get((Object)groupName, (Object)(roleName = (String)cell.getColumnKey()));
            if (privileges == null) {
                privileges = new HashSet();
                this.groupRolePrivilegeTable.put((Object)groupName, (Object)roleName, privileges);
            }
            privileges.addAll((Collection)cell.getValue());
        }
    }

    private void parseIni(String database, Ini ini, List<? extends PrivilegeValidator> validators, Path policyPath, Table<String, String, Set<String>> groupRolePrivilegeTable) {
        Ini.Section groupsSection;
        Ini.Section privilegesSection = ini.getSection("roles");
        boolean invalidConfiguration = false;
        if (privilegesSection == null) {
            String errMsg = String.format("Section %s empty for %s", "roles", policyPath);
            LOGGER.warn(errMsg);
            this.configErrors.add(errMsg);
            invalidConfiguration = true;
        }
        if ((groupsSection = ini.getSection("groups")) == null) {
            String warnMsg = String.format("Section %s empty for %s", "groups", policyPath);
            LOGGER.warn(warnMsg);
            this.configErrors.add(warnMsg);
            invalidConfiguration = true;
        }
        if (!invalidConfiguration) {
            this.parsePrivileges(database, privilegesSection, groupsSection, validators, policyPath, groupRolePrivilegeTable);
        }
    }

    private void parsePrivileges(@Nullable String database, Ini.Section rolesSection, Ini.Section groupsSection, List<? extends PrivilegeValidator> validators, Path policyPath, Table<String, String, Set<String>> groupRolePrivilegeTable) {
        HashMultimap roleNameToPrivilegeMap = HashMultimap.create();
        for (Map.Entry entry : rolesSection.entrySet()) {
            String errMsg;
            String roleName = (String)this.stringInterner.intern((Object)Strings.nullToEmpty((String)((String)entry.getKey())).trim());
            String roleValue = Strings.nullToEmpty((String)((String)entry.getValue())).trim();
            boolean invalidConfiguration = false;
            if (roleName.isEmpty()) {
                errMsg = String.format("Empty role name encountered in %s", policyPath);
                LOGGER.warn(errMsg);
                this.configErrors.add(errMsg);
                invalidConfiguration = true;
            }
            if (roleValue.isEmpty()) {
                errMsg = String.format("Empty role value encountered in %s", policyPath);
                LOGGER.warn(errMsg);
                this.configErrors.add(errMsg);
                invalidConfiguration = true;
            }
            if (roleNameToPrivilegeMap.containsKey((Object)roleName)) {
                String warnMsg = String.format("Role %s defined twice in %s", roleName, policyPath);
                LOGGER.warn(warnMsg);
                this.configWarnings.add(warnMsg);
            }
            Set privileges = PrivilegeUtils.toPrivilegeStrings((String)roleValue);
            if (invalidConfiguration || privileges == null) continue;
            HashSet internedPrivileges = Sets.newHashSet();
            for (String privilege : privileges) {
                for (PrivilegeValidator privilegeValidator : validators) {
                    privilegeValidator.validate(new PrivilegeValidatorContext(database, privilege.trim()));
                }
                internedPrivileges.add(this.stringInterner.intern((Object)privilege));
            }
            roleNameToPrivilegeMap.putAll((Object)roleName, (Iterable)internedPrivileges);
        }
        Splitter roleSplitter = PolicyFileConstants.ROLE_SPLITTER.omitEmptyStrings().trimResults();
        for (Map.Entry entry : groupsSection.entrySet()) {
            String groupName = (String)this.stringInterner.intern((Object)Strings.nullToEmpty((String)((String)entry.getKey())).trim());
            String groupPrivileges = Strings.nullToEmpty((String)((String)entry.getValue())).trim();
            for (String roleName : roleSplitter.split((CharSequence)groupPrivileges)) {
                if (roleNameToPrivilegeMap.containsKey((Object)(roleName = (String)this.stringInterner.intern((Object)roleName)))) {
                    HashSet privileges = (HashSet)groupRolePrivilegeTable.get((Object)groupName, (Object)roleName);
                    if (privileges == null) {
                        privileges = new HashSet();
                        groupRolePrivilegeTable.put((Object)groupName, (Object)roleName, privileges);
                    }
                    privileges.addAll(roleNameToPrivilegeMap.get((Object)roleName));
                    continue;
                }
                String warnMsg = String.format("Role %s for group %s does not exist in privileges section in %s", roleName, groupName, policyPath);
                LOGGER.warn(warnMsg);
                this.configWarnings.add(warnMsg);
            }
        }
    }

    public Table<String, String, Set<String>> getGroupRolePrivilegeTable() {
        return this.groupRolePrivilegeTable;
    }
}

