/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.service.thrift.HAClientInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryServiceClientPoolFactory
extends BasePooledObjectFactory<SentryPolicyServiceClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryServiceClientPoolFactory.class);
    private Configuration conf;

    public SentryServiceClientPoolFactory(Configuration conf) {
        this.conf = conf;
    }

    public SentryPolicyServiceClient create() throws Exception {
        LOGGER.debug("Creating Sentry Service Client...");
        boolean haEnabled = this.conf.getBoolean("sentry.ha.enabled", false);
        if (haEnabled) {
            return (SentryPolicyServiceClient)Proxy.newProxyInstance(SentryPolicyServiceClientDefaultImpl.class.getClassLoader(), SentryPolicyServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new HAClientInvocationHandler(this.conf));
        }
        return new SentryPolicyServiceClientDefaultImpl(this.conf);
    }

    public PooledObject<SentryPolicyServiceClient> wrap(SentryPolicyServiceClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<SentryPolicyServiceClient> pooledObject) {
        SentryPolicyServiceClient client = (SentryPolicyServiceClient)pooledObject.getObject();
        LOGGER.debug("Destroying Sentry Service Client: " + client);
        if (client != null) {
            client.close();
        }
    }
}

