/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryClientInvocationHandler;
import org.apache.sentry.service.thrift.SentryServiceClientPoolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolClientInvocationHandler
extends SentryClientInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolClientInvocationHandler.class);
    private final Configuration conf;
    private PooledObjectFactory<SentryPolicyServiceClient> poolFactory;
    private GenericObjectPool<SentryPolicyServiceClient> pool;
    private GenericObjectPoolConfig poolConfig;
    private int connectionRetryTotal;
    private static final String POOL_EXCEPTION_MESSAGE = "Pool exception occured ";

    public PoolClientInvocationHandler(Configuration conf) throws Exception {
        this.conf = conf;
        this.readConfiguration();
        this.poolFactory = new SentryServiceClientPoolFactory(conf);
        this.pool = new GenericObjectPool(this.poolFactory, this.poolConfig, new AbandonedConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeImpl(Object proxy, Method method, Object[] args) throws Exception {
        int retryCount = 0;
        Object result = null;
        while (retryCount < this.connectionRetryTotal) {
            try {
                result = this.invokeFromPool(proxy, method, args);
                break;
            }
            catch (TTransportException e) {
                GenericObjectPool<SentryPolicyServiceClient> genericObjectPool = this.pool;
                synchronized (genericObjectPool) {
                    if (this.pool.getNumIdle() + this.pool.getNumActive() < this.pool.getMaxTotal()) {
                        this.pool.addObject();
                    }
                }
                if (++retryCount != this.connectionRetryTotal) continue;
                throw new SentryUserException(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Object invokeFromPool(Object proxy, Method method, Object[] args) throws Exception {
        SentryPolicyServiceClient client;
        Object result = null;
        try {
            client = (SentryPolicyServiceClient)this.pool.borrowObject();
        }
        catch (Exception e) {
            LOGGER.debug(POOL_EXCEPTION_MESSAGE, (Throwable)e);
            throw new SentryUserException(e.getMessage(), (Throwable)e);
        }
        try {
            result = method.invoke((Object)client, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getCause();
            if (targetException != null && targetException instanceof SentryUserException) {
                Throwable sentryTargetException = targetException.getCause();
                if (sentryTargetException != null && sentryTargetException instanceof TTransportException) {
                    this.pool.invalidateObject((Object)client);
                    throw new TTransportException(sentryTargetException);
                }
                throw (SentryUserException)targetException;
            }
            throw e;
        }
        finally {
            try {
                this.pool.returnObject((Object)client);
            }
            catch (Exception e) {
                LOGGER.error(POOL_EXCEPTION_MESSAGE, (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    @Override
    public void close() {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            LOGGER.debug(POOL_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private void readConfiguration() {
        this.poolConfig = new GenericObjectPoolConfig();
        this.poolConfig.setMaxTotal(this.conf.getInt("sentry.service.client.connection.pool.max-total", 8));
        this.poolConfig.setMinIdle(this.conf.getInt("sentry.service.client.connection.pool.min-idle", 0));
        this.poolConfig.setMaxIdle(this.conf.getInt("sentry.service.client.connection.pool.max-idle", 8));
        this.connectionRetryTotal = this.conf.getInt("sentry.service.client.connection.pool.retry-total", 3);
    }
}

