/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.provider.db.service.persistent.HAContext;
import org.apache.sentry.provider.db.service.persistent.ServiceManager;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.service.thrift.SentryClientInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HAClientInvocationHandler
extends SentryClientInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HAClientInvocationHandler.class);
    private final Configuration conf;
    private ServiceManager manager;
    private ServiceInstance<Void> currentServiceInstance;
    private SentryPolicyServiceClient client = null;
    private static final String THRIFT_EXCEPTION_MESSAGE = "Thrift exception occured ";
    public static final String SENTRY_HA_ERROR_MESSAGE = "No Sentry server available. Please ensure that at least one Sentry server is online";

    public HAClientInvocationHandler(Configuration conf) throws Exception {
        this.conf = conf;
        this.checkClientConf();
    }

    @Override
    public Object invokeImpl(Object proxy, Method method, Object[] args) throws SentryUserException {
        Object result = null;
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (this.client == null) {
                this.renewSentryClient();
            }
            result = method.invoke((Object)this.client, args);
        }
        catch (IllegalAccessException e) {
            throw new SentryUserException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SentryUserException) {
                throw (SentryUserException)e.getTargetException();
            }
            LOGGER.warn("Thrift exception occured : Error in connect current service, will retry other service.", (Throwable)e);
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (IOException e1) {
            throw new SentryUserException("Error connecting to sentry service " + e1.getMessage(), (Throwable)e1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewSentryClient() throws IOException {
        try {
            this.manager = new ServiceManager(HAContext.getHAContext(this.conf));
        }
        catch (Exception e1) {
            throw new IOException("Failed to extract Sentry node info from zookeeper", e1);
        }
        try {
            while (true) {
                this.currentServiceInstance = this.manager.getServiceInstance();
                if (this.currentServiceInstance == null) {
                    throw new IOException(SENTRY_HA_ERROR_MESSAGE);
                }
                InetSocketAddress serverAddress = ServiceManager.convertServiceInstance(this.currentServiceInstance);
                this.conf.set("sentry.service.client.server.rpc-address", serverAddress.getHostName());
                this.conf.setInt("sentry.service.client.server.rpc-port", serverAddress.getPort());
                try {
                    this.client = new SentryPolicyServiceClientDefaultImpl(this.conf);
                    LOGGER.info("Sentry Client using server " + serverAddress.getHostName() + ":" + serverAddress.getPort());
                }
                catch (IOException e) {
                    this.manager.reportError(this.currentServiceInstance);
                    LOGGER.info("Transport exception while opening transport:", (Object)e, (Object)e.getMessage());
                    continue;
                }
                break;
            }
        }
        finally {
            this.manager.close();
        }
    }

    private void checkClientConf() {
        if (this.conf.getBoolean("sentry.ha.zookeeper.security", false)) {
            String serverPrincipal = (String)Preconditions.checkNotNull((Object)this.conf.get("sentry.service.server.principal"), (Object)"sentry.service.server.principal is required");
            Preconditions.checkArgument((boolean)serverPrincipal.contains("_HOST"), (Object)("sentry.service.server.principal : " + serverPrincipal + " should contain " + "_HOST"));
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

