/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.codahale.metrics.servlets.AdminServlet;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.provider.db.service.thrift.SentryAuthFilter;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryWebServer.class);
    Server server;
    int port;

    public SentryWebServer(List<EventListener> listeners, int port, Configuration conf) {
        this.port = port;
        this.server = new Server(port);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder servletHolder = new ServletHolder(AdminServlet.class);
        servletContextHandler.addServlet(servletHolder, "/*");
        for (EventListener listener : listeners) {
            servletContextHandler.addEventListener(listener);
        }
        String authMethod = conf.get("sentry.service.web.authentication.type");
        if (!"NONE".equals(authMethod)) {
            FilterHolder filterHolder = servletContextHandler.addFilter(SentryAuthFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            filterHolder.setInitParameters(SentryWebServer.loadWebAuthenticationConf(conf));
        }
        this.server.setHandler((Handler)servletContextHandler);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isAlive() {
        return this.server != null && this.server.isStarted();
    }

    private static Map<String, String> loadWebAuthenticationConf(Configuration conf) {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("config.prefix", "sentry.service.web.authentication");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        if (allowUsers == null || allowUsers.equals("")) {
            allowUsers = conf.get("sentry.service.allow.connect");
            conf.set("sentry.service.web.authentication.allow.connect.users", allowUsers);
        }
        SentryWebServer.validateConf(conf);
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith("sentry.service.web.authentication")) continue;
            String value = conf.get(name);
            prop.put(name, value);
        }
        return prop;
    }

    private static void validateConf(Configuration conf) {
        String authHandlerName = conf.get("sentry.service.web.authentication.type");
        Preconditions.checkNotNull((Object)authHandlerName, (Object)"Web authHandler should not be null.");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        Preconditions.checkNotNull((Object)allowUsers, (Object)"Allow connect user(s) should not be null.");
        if ("KERBEROS".equalsIgnoreCase(authHandlerName)) {
            String principal = conf.get("sentry.service.web.authentication.kerberos.principal");
            Preconditions.checkNotNull((Object)principal, (Object)"Kerberos principal should not be null.");
            Preconditions.checkArgument((principal.length() != 0 ? 1 : 0) != 0, (Object)"Kerberos principal is not right.");
            String keytabFile = conf.get("sentry.service.web.authentication.kerberos.keytab");
            Preconditions.checkNotNull((Object)keytabFile, (Object)"Keytab File should not be null.");
            Preconditions.checkArgument((keytabFile.length() != 0 ? 1 : 0) != 0, (Object)"Keytab File is not right.");
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytabFile);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Can't use Kerberos authentication, principal [" + principal + "] keytab [" + keytabFile + "]", ex);
            }
            LOGGER.info("Using Kerberos authentication, principal [" + principal + "] keytab [" + keytabFile + "]");
        }
    }
}

