/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyService;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryConfigValueRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryConfigValueResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryExportMappingDataRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryExportMappingDataResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryImportMappingDataRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryImportMappingDataResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryMappingData;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceUtil;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;
import org.apache.sentry.service.thrift.shim.ShimLoader;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryPolicyServiceClientDefaultImpl
implements SentryPolicyServiceClient {
    private final Configuration conf;
    private final InetSocketAddress serverAddress;
    private final boolean kerberos;
    private final boolean other;
    private String[] serverPrincipalParts;
    private SentryPolicyService.Client client;
    private TTransport transport;
    private int connectionTimeout;
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryPolicyServiceClient.class);
    private static final String THRIFT_EXCEPTION_MESSAGE = "Thrift exception occurred ";

    public SentryPolicyServiceClientDefaultImpl(Configuration conf) throws IOException {
        this.conf = conf;
        Preconditions.checkNotNull((Object)this.conf, (Object)"Configuration object cannot be null");
        this.serverAddress = NetUtils.createSocketAddr((String)((String)Preconditions.checkNotNull((Object)conf.get("sentry.service.client.server.rpc-address"), (Object)"Config key sentry.service.client.server.rpc-address is required")), (int)conf.getInt("sentry.service.client.server.rpc-port", 8038));
        this.connectionTimeout = conf.getInt("sentry.service.client.server.rpc-connection-timeout", 200000);
        this.kerberos = "kerberos".equalsIgnoreCase(conf.get("sentry.service.security.mode", "kerberos").trim());
        this.other = "other".equalsIgnoreCase(conf.get("sentry.service.security.mode", "kerberos").trim());
        System.setProperty("sentry.service.security.mode", conf.get("sentry.service.security.mode", "kerberos"));
        HadoopThriftAuthBridge hadoopThriftAuthBridge = ShimLoader.getHadoopThriftAuthBridge();
        this.transport = new TSocket(this.serverAddress.getHostName(), this.serverAddress.getPort(), this.connectionTimeout);
        boolean wrapUgi = "true".equalsIgnoreCase(conf.get("sentry.service.security.use.ugi", "true"));
        if (this.kerberos) {
            String serverPrincipal = (String)Preconditions.checkNotNull((Object)conf.get("sentry.service.server.principal"), (Object)"sentry.service.server.principal is required");
            serverPrincipal = SecurityUtil.getServerPrincipal((String)serverPrincipal, (InetAddress)this.serverAddress.getAddress());
            LOGGER.debug("Using server kerberos principal: " + serverPrincipal);
            this.serverPrincipalParts = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkArgument((this.serverPrincipalParts.length == 3 ? 1 : 0) != 0, (Object)("Kerberos principal should have 3 parts: " + serverPrincipal));
            this.transport = hadoopThriftAuthBridge.createClient().createClientTransport(serverPrincipal, this.serverAddress.getHostName(), this.transport, wrapUgi);
        } else if (this.other) {
            this.transport = hadoopThriftAuthBridge.createClient().createClientTransport(null, null, this.transport, wrapUgi);
        }
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new IOException("Transport exception while opening transport: " + e.getMessage(), e);
        }
        LOGGER.debug("Successfully opened transport: " + this.transport + " to " + this.serverAddress);
        TMultiplexedProtocol protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol(this.transport), "SentryPolicyService");
        this.client = new SentryPolicyService.Client((TProtocol)protocol);
        LOGGER.debug("Successfully created client");
    }

    @Override
    public synchronized void createRole(String requestorUserName, String roleName) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void dropRole(String requestorUserName, String roleName) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, false);
    }

    @Override
    public void dropRoleIfExists(String requestorUserName, String roleName) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, true);
    }

    private void dropRole(String requestorUserName, String roleName, boolean ifExists) throws SentryUserException {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        try {
            TDropSentryRoleResponse response = this.client.drop_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (ifExists && status == Status.NO_SUCH_OBJECT) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized Set<TSentryRole> listRolesByGroupName(String requestorUserName, String groupName) throws SentryUserException {
        TListSentryRolesRequest request = new TListSentryRolesRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setGroupName(groupName);
        try {
            TListSentryRolesResponse response = this.client.list_sentry_roles_by_group(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getRoles();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Set<TSentryPrivilege> listAllPrivilegesByRoleName(String requestorUserName, String roleName) throws SentryUserException {
        return this.listPrivilegesByRoleName(requestorUserName, roleName, null);
    }

    @Override
    public Set<TSentryPrivilege> listPrivilegesByRoleName(String requestorUserName, String roleName, List<? extends Authorizable> authorizable) throws SentryUserException {
        TListSentryPrivilegesRequest request = new TListSentryPrivilegesRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        if (authorizable != null && !authorizable.isEmpty()) {
            TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(authorizable);
            request.setAuthorizableHierarchy(tSentryAuthorizable);
        }
        try {
            TListSentryPrivilegesResponse response = this.client.list_sentry_privileges_by_role(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Set<TSentryRole> listRoles(String requestorUserName) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, null);
    }

    @Override
    public Set<TSentryRole> listUserRoles(String requestorUserName) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, "*");
    }

    @Override
    public TSentryPrivilege grantURIPrivilege(String requestorUserName, String roleName, String server, String uri) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, null, "*");
    }

    @Override
    public TSentryPrivilege grantURIPrivilege(String requestorUserName, String roleName, String server, String uri, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, null, "*", grantOption);
    }

    @Override
    public void grantServerPrivilege(String requestorUserName, String roleName, String server, String action) throws SentryUserException {
        this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, null, action);
    }

    @Override
    @Deprecated
    public TSentryPrivilege grantServerPrivilege(String requestorUserName, String roleName, String server, Boolean grantOption) throws SentryUserException {
        return this.grantServerPrivilege(requestorUserName, roleName, server, "*", grantOption);
    }

    @Override
    public TSentryPrivilege grantServerPrivilege(String requestorUserName, String roleName, String server, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, null, action, grantOption);
    }

    @Override
    public TSentryPrivilege grantDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, null, action);
    }

    @Override
    public TSentryPrivilege grantDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, null, action, grantOption);
    }

    @Override
    public TSentryPrivilege grantTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, null, action);
    }

    @Override
    public TSentryPrivilege grantTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, null, action, grantOption);
    }

    @Override
    public TSentryPrivilege grantColumnPrivilege(String requestorUserName, String roleName, String server, String db, String table, String columnName, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columnName, action);
    }

    @Override
    public TSentryPrivilege grantColumnPrivilege(String requestorUserName, String roleName, String server, String db, String table, String columnName, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columnName, action, grantOption);
    }

    @Override
    public Set<TSentryPrivilege> grantColumnsPrivileges(String requestorUserName, String roleName, String server, String db, String table, List<String> columnNames, String action) throws SentryUserException {
        return this.grantPrivileges(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columnNames, action);
    }

    @Override
    public Set<TSentryPrivilege> grantColumnsPrivileges(String requestorUserName, String roleName, String server, String db, String table, List<String> columnNames, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivileges(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columnNames, action, grantOption);
    }

    @VisibleForTesting
    public static TSentryAuthorizable setupSentryAuthorizable(List<? extends Authorizable> authorizable) {
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        for (Authorizable authorizable2 : authorizable) {
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Server.toString())) {
                tSentryAuthorizable.setServer(authorizable2.getName());
                continue;
            }
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.URI.toString())) {
                tSentryAuthorizable.setUri(authorizable2.getName());
                continue;
            }
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Db.toString())) {
                tSentryAuthorizable.setDb(authorizable2.getName());
                continue;
            }
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Table.toString())) {
                tSentryAuthorizable.setTable(authorizable2.getName());
                continue;
            }
            if (!authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Column.toString())) continue;
            tSentryAuthorizable.setColumn(authorizable2.getName());
        }
        return tSentryAuthorizable;
    }

    private TSentryPrivilege grantPrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String column, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, scope, serverName, uri, db, table, column, action, false);
    }

    private TSentryPrivilege grantPrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String column, String action, Boolean grantOption) throws SentryUserException {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        Set<TSentryPrivilege> privileges = this.convertColumnPrivilege(requestorUserName, scope, serverName, uri, db, table, column, action, grantOption);
        request.setPrivileges(privileges);
        try {
            TAlterSentryRoleGrantPrivilegeResponse response = this.client.alter_sentry_role_grant_privilege(request);
            Status.throwIfNotOk(response.getStatus());
            if (response.isSetPrivileges() && response.getPrivilegesSize() > 0) {
                return response.getPrivileges().iterator().next();
            }
            return new TSentryPrivilege();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private Set<TSentryPrivilege> grantPrivileges(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, List<String> columns, String action) throws SentryUserException {
        return this.grantPrivileges(requestorUserName, roleName, scope, serverName, uri, db, table, columns, action, false);
    }

    private Set<TSentryPrivilege> grantPrivileges(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, List<String> columns, String action, Boolean grantOption) throws SentryUserException {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        Set<TSentryPrivilege> privileges = this.convertColumnPrivileges(requestorUserName, scope, serverName, uri, db, table, columns, action, grantOption);
        request.setPrivileges(privileges);
        try {
            TAlterSentryRoleGrantPrivilegeResponse response = this.client.alter_sentry_role_grant_privilege(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void revokeURIPrivilege(String requestorUserName, String roleName, String server, String uri) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, null, "*");
    }

    @Override
    public void revokeURIPrivilege(String requestorUserName, String roleName, String server, String uri, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, null, "*", grantOption);
    }

    @Override
    public void revokeServerPrivilege(String requestorUserName, String roleName, String server, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, null, action);
    }

    @Override
    public void revokeServerPrivilege(String requestorUserName, String roleName, String server, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, null, action, grantOption);
    }

    @Override
    public void revokeServerPrivilege(String requestorUserName, String roleName, String server, boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, null, "*", grantOption);
    }

    @Override
    public void revokeDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, null, action);
    }

    @Override
    public void revokeDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, null, action, grantOption);
    }

    @Override
    public void revokeTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, null, action);
    }

    @Override
    public void revokeTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, null, action, grantOption);
    }

    @Override
    public void revokeColumnPrivilege(String requestorUserName, String roleName, String server, String db, String table, String columnName, String action) throws SentryUserException {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)columnName);
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, (List<String>)listBuilder.build(), action);
    }

    @Override
    public void revokeColumnPrivilege(String requestorUserName, String roleName, String server, String db, String table, String columnName, String action, Boolean grantOption) throws SentryUserException {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)columnName);
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, (List<String>)listBuilder.build(), action, grantOption);
    }

    @Override
    public void revokeColumnsPrivilege(String requestorUserName, String roleName, String server, String db, String table, List<String> columns, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columns, action);
    }

    @Override
    public void revokeColumnsPrivilege(String requestorUserName, String roleName, String server, String db, String table, List<String> columns, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.COLUMN, server, null, db, table, columns, action, grantOption);
    }

    private void revokePrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, List<String> columns, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, scope, serverName, uri, db, table, columns, action, false);
    }

    private void revokePrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, List<String> columns, String action, Boolean grantOption) throws SentryUserException {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        Set<TSentryPrivilege> privileges = this.convertColumnPrivileges(requestorUserName, scope, serverName, uri, db, table, columns, action, grantOption);
        request.setPrivileges(privileges);
        try {
            TAlterSentryRoleRevokePrivilegeResponse response = this.client.alter_sentry_role_revoke_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private Set<TSentryPrivilege> convertColumnPrivileges(String requestorUserName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, List<String> columns, String action, Boolean grantOption) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (columns == null || columns.isEmpty()) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope(scope.toString());
            privilege.setServerName(serverName);
            privilege.setURI(uri);
            privilege.setDbName(db);
            privilege.setTableName(table);
            privilege.setColumnName(null);
            privilege.setAction(action);
            privilege.setCreateTime(System.currentTimeMillis());
            privilege.setGrantOption(this.convertTSentryGrantOption(grantOption));
            setBuilder.add((Object)privilege);
        } else {
            for (String column : columns) {
                TSentryPrivilege privilege = new TSentryPrivilege();
                privilege.setPrivilegeScope(scope.toString());
                privilege.setServerName(serverName);
                privilege.setURI(uri);
                privilege.setDbName(db);
                privilege.setTableName(table);
                privilege.setColumnName(column);
                privilege.setAction(action);
                privilege.setCreateTime(System.currentTimeMillis());
                privilege.setGrantOption(this.convertTSentryGrantOption(grantOption));
                setBuilder.add((Object)privilege);
            }
        }
        return setBuilder.build();
    }

    private Set<TSentryPrivilege> convertColumnPrivilege(String requestorUserName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String column, String action, Boolean grantOption) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope(scope.toString());
        privilege.setServerName(serverName);
        privilege.setURI(uri);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setColumnName(column);
        privilege.setAction(action);
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(this.convertTSentryGrantOption(grantOption));
        setBuilder.add((Object)privilege);
        return setBuilder.build();
    }

    private TSentryGrantOption convertTSentryGrantOption(Boolean grantOption) {
        if (grantOption == null) {
            return TSentryGrantOption.UNSET;
        }
        if (grantOption.equals(true)) {
            return TSentryGrantOption.TRUE;
        }
        if (grantOption.equals(false)) {
            return TSentryGrantOption.FALSE;
        }
        return TSentryGrantOption.FALSE;
    }

    @Override
    public Set<String> listPrivilegesForProvider(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizable) throws SentryUserException {
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles());
        TListSentryPrivilegesForProviderRequest request = new TListSentryPrivilegesForProviderRequest(2, groups, thriftRoleSet);
        if (authorizable != null && authorizable.length > 0) {
            TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(Lists.newArrayList((Object[])authorizable));
            request.setAuthorizableHierarchy(tSentryAuthorizable);
        }
        try {
            TListSentryPrivilegesForProviderResponse response = this.client.list_sentry_privileges_for_provider(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized void grantRoleToGroup(String requestorUserName, String groupName, String roleName) throws SentryUserException {
        this.grantRoleToGroups(requestorUserName, roleName, Sets.newHashSet((Object[])new String[]{groupName}));
    }

    @Override
    public synchronized void revokeRoleFromGroup(String requestorUserName, String groupName, String roleName) throws SentryUserException {
        this.revokeRoleFromGroups(requestorUserName, roleName, Sets.newHashSet((Object[])new String[]{groupName}));
    }

    @Override
    public synchronized void grantRoleToGroups(String requestorUserName, String roleName, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest(2, requestorUserName, roleName, this.convert2TGroups(groups));
        try {
            TAlterSentryRoleAddGroupsResponse response = this.client.alter_sentry_role_add_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized void revokeRoleFromGroups(String requestorUserName, String roleName, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest(2, requestorUserName, roleName, this.convert2TGroups(groups));
        try {
            TAlterSentryRoleDeleteGroupsResponse response = this.client.alter_sentry_role_delete_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private Set<TSentryGroup> convert2TGroups(Set<String> groups) {
        HashSet tGroups = Sets.newHashSet();
        if (groups != null) {
            for (String groupName : groups) {
                tGroups.add(new TSentryGroup(groupName));
            }
        }
        return tGroups;
    }

    @Override
    public synchronized void dropPrivileges(String requestorUserName, List<? extends Authorizable> authorizableObjects) throws SentryUserException {
        TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(authorizableObjects);
        TDropPrivilegesRequest request = new TDropPrivilegesRequest(2, requestorUserName, tSentryAuthorizable);
        try {
            TDropPrivilegesResponse response = this.client.drop_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized void renamePrivileges(String requestorUserName, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables) throws SentryUserException {
        TSentryAuthorizable tOldSentryAuthorizable = SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(oldAuthorizables);
        TSentryAuthorizable tNewSentryAuthorizable = SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(newAuthorizables);
        TRenamePrivilegesRequest request = new TRenamePrivilegesRequest(2, requestorUserName, tOldSentryAuthorizable, tNewSentryAuthorizable);
        try {
            TRenamePrivilegesResponse response = this.client.rename_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized Map<TSentryAuthorizable, TSentryPrivilegeMap> listPrivilegsbyAuthorizable(String requestorUserName, Set<List<? extends Authorizable>> authorizables, Set<String> groups, ActiveRoleSet roleSet) throws SentryUserException {
        TreeSet authSet = Sets.newTreeSet();
        for (List<? extends Authorizable> authorizableHierarchy : authorizables) {
            authSet.add(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable(authorizableHierarchy));
        }
        TListSentryPrivilegesByAuthRequest request = new TListSentryPrivilegesByAuthRequest(2, requestorUserName, authSet);
        if (groups != null) {
            request.setGroups(groups);
        }
        if (roleSet != null) {
            request.setRoleSet(new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles()));
        }
        try {
            TListSentryPrivilegesByAuthResponse response = this.client.list_sentry_privileges_by_authorizable(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivilegesMapByAuth();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public String getConfigValue(String propertyName, String defaultValue) throws SentryUserException {
        TSentryConfigValueRequest request = new TSentryConfigValueRequest(2, propertyName);
        if (defaultValue != null) {
            request.setDefaultValue(defaultValue);
        }
        try {
            TSentryConfigValueResponse response = this.client.get_sentry_config_value(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getValue();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }

    @Override
    public void importPolicy(Map<String, Map<String, Set<String>>> policyFileMappingData, String requestorUserName, boolean isOverwriteRole) throws SentryUserException {
        try {
            TSentryMappingData tSentryMappingData = new TSentryMappingData();
            tSentryMappingData.setGroupRolesMap(policyFileMappingData.get("groups"));
            tSentryMappingData.setRolePrivilegesMap(this.convertRolePrivilegesMapForSentryDB(policyFileMappingData.get("roles")));
            TSentryImportMappingDataRequest request = new TSentryImportMappingDataRequest(2, requestorUserName, isOverwriteRole, tSentryMappingData);
            TSentryImportMappingDataResponse response = this.client.import_sentry_mapping_data(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private Map<String, Set<TSentryPrivilege>> convertRolePrivilegesMapForSentryDB(Map<String, Set<String>> rolePrivilegesMap) {
        HashMap rolePrivilegesMapResult = Maps.newHashMap();
        if (rolePrivilegesMap != null) {
            for (String tempRoleName : rolePrivilegesMap.keySet()) {
                HashSet tempTSentryPrivileges = Sets.newHashSet();
                Set<String> tempPrivileges = rolePrivilegesMap.get(tempRoleName);
                for (String tempPrivilege : tempPrivileges) {
                    tempTSentryPrivileges.add(SentryServiceUtil.convertToTSentryPrivilege(tempPrivilege));
                }
                rolePrivilegesMapResult.put(tempRoleName, tempTSentryPrivileges);
            }
        }
        return rolePrivilegesMapResult;
    }

    @Override
    public Map<String, Map<String, Set<String>>> exportPolicy(String requestorUserName) throws SentryUserException {
        TSentryExportMappingDataRequest request = new TSentryExportMappingDataRequest(2, requestorUserName);
        try {
            TSentryExportMappingDataResponse response = this.client.export_sentry_mapping_data(request);
            Status.throwIfNotOk(response.getStatus());
            TSentryMappingData tSentryMappingData = response.getMappingData();
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("groups", tSentryMappingData.getGroupRolesMap());
            resultMap.put("roles", this.convertRolePrivilegesMapForPolicyFile(tSentryMappingData.getRolePrivilegesMap()));
            return resultMap;
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private Map<String, Set<String>> convertRolePrivilegesMapForPolicyFile(Map<String, Set<TSentryPrivilege>> rolePrivilegesMap) {
        HashMap rolePrivilegesMapForFile = Maps.newHashMap();
        if (rolePrivilegesMap != null) {
            for (String tempRoleName : rolePrivilegesMap.keySet()) {
                Set<TSentryPrivilege> tempSentryPrivileges = rolePrivilegesMap.get(tempRoleName);
                HashSet tempStrPrivileges = Sets.newHashSet();
                for (TSentryPrivilege tSentryPrivilege : tempSentryPrivileges) {
                    String privilegeStr = SentryServiceUtil.convertTSentryPrivilegeToStr(tSentryPrivilege);
                    if (StringUtils.isEmpty((String)privilegeStr)) continue;
                    tempStrPrivileges.add(privilegeStr);
                }
                rolePrivilegesMapForFile.put(tempRoleName, tempStrPrivileges);
            }
        }
        return rolePrivilegesMapForFile;
    }

    public static class UgiSaslClientTransport
    extends TSaslClientTransport {
        protected UserGroupInformation ugi = null;

        public UgiSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport, boolean wrapUgi) throws IOException {
            super(mechanism, authorizationId, protocol, serverName, props, cbh, transport);
            if (wrapUgi) {
                this.ugi = UserGroupInformation.getLoginUser();
            }
        }

        public void open() throws TTransportException {
            if (this.ugi == null) {
                this.baseOpen();
            } else {
                try {
                    if (this.ugi.isFromKeytab()) {
                        this.ugi.checkTGTAndReloginFromKeytab();
                    }
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws TTransportException {
                            UgiSaslClientTransport.this.baseOpen();
                            return null;
                        }
                    });
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to open SASL transport", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new TTransportException("Interrupted while opening underlying transport", (Throwable)e);
                }
            }
        }

        private void baseOpen() throws TTransportException {
            super.open();
        }
    }
}

