/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.SentryMetricsServletContextListener;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;

public class SentryMetrics {
    private static SentryMetrics sentryMetrics = null;
    private boolean reportingInitialized = false;
    private boolean gaugesAdded = false;
    public final Timer createRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"create-role"}));
    public final Timer dropRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"drop-role"}));
    public final Timer grantRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"grant-role"}));
    public final Timer revokeRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"revoke-role"}));
    public final Timer grantTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"grant-privilege"}));
    public final Timer revokeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"revoke-privilege"}));
    public final Timer dropPrivilegeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"drop-privilege"}));
    public final Timer renamePrivilegeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"rename-privilege"}));
    public final Timer listRolesByGroupTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"list-roles-by-group"}));
    public final Timer listPrivilegesByRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"list-privileges-by-role"}));
    public final Timer listPrivilegesForProviderTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"list-privileges-for-provider"}));
    public final Timer listPrivilegesByAuthorizableTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, (String[])new String[]{"list-privileges-by-authorizable"}));

    private SentryMetrics() {
        this.registerMetricSet("gc", (MetricSet)new GarbageCollectorMetricSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("memory", (MetricSet)new MemoryUsageGaugeSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("threads", (MetricSet)new ThreadStatesGaugeSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
    }

    public static synchronized SentryMetrics getInstance() {
        if (sentryMetrics == null) {
            sentryMetrics = new SentryMetrics();
        }
        return sentryMetrics;
    }

    public void addSentryStoreGauges(SentryStore sentryStore) {
        if (!this.gaugesAdded) {
            this.addGauge(SentryStore.class, "role_count", sentryStore.getRoleCountGauge());
            this.addGauge(SentryStore.class, "privilege_count", sentryStore.getPrivilegeCountGauge());
            this.addGauge(SentryStore.class, "group_count", sentryStore.getGroupCountGauge());
            this.gaugesAdded = true;
        }
    }

    public synchronized void initReporting(Reporting reporting) {
        if (!this.reportingInitialized) {
            switch (reporting) {
                case CONSOLE: {
                    ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)SentryMetricsServletContextListener.METRIC_REGISTRY).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    consoleReporter.start(1L, TimeUnit.SECONDS);
                    break;
                }
                case JMX: {
                    JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)SentryMetricsServletContextListener.METRIC_REGISTRY).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    jmxReporter.start();
                }
            }
        }
    }

    private <T, V> void addGauge(Class<T> tClass, String gaugeName, Gauge<V> gauge) {
        SentryMetricsServletContextListener.METRIC_REGISTRY.register(MetricRegistry.name(tClass, (String[])new String[]{gaugeName}), gauge);
    }

    private void registerMetricSet(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerMetricSet(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public static enum Reporting {
        JMX,
        CONSOLE;

    }
}

