/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.codahale.metrics.Gauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.FetchGroup;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryVersion;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryMappingData;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryStore {
    private static final UUID SERVER_UUID = UUID.randomUUID();
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryStore.class);
    public static String NULL_COL = "__NULL__";
    static final String DEFAULT_DATA_DIR = "sentry_policy_db";
    private static final Set<String> ALL_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "select", "insert", "alter", "create", "drop", "index", "lock"});
    private static final Set<String> PARTIAL_REVOKE_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "ALL".toLowerCase(), "select", "insert"});
    private long commitSequenceId = 0L;
    private final PersistenceManagerFactory pmf;
    private Configuration conf;
    private PrivCleaner privCleaner = null;
    private Thread privCleanerThread = null;

    public SentryStore(Configuration conf) throws SentryNoSuchObjectException, SentryAccessDeniedException, SentryConfigurationException, IOException {
        this.conf = conf;
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)ServiceConstants.ServerConfig.SENTRY_STORE_DEFAULTS);
        String jdbcUrl = conf.get("sentry.store.jdbc.url", "").trim();
        Preconditions.checkArgument((!jdbcUrl.isEmpty() ? 1 : 0) != 0, (Object)"Required parameter sentry.store.jdbc.url missing");
        String user = conf.get("sentry.store.jdbc.user", "Sentry").trim();
        char[] passTmp = conf.getPassword("sentry.store.jdbc.password");
        String pass = null;
        if (passTmp == null) {
            throw new SentryConfigurationException("Error reading sentry.store.jdbc.password");
        }
        pass = new String(passTmp);
        String driverName = conf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("javax.jdo.option.ConnectionURL", jdbcUrl);
        prop.setProperty("javax.jdo.option.ConnectionUserName", user);
        prop.setProperty("javax.jdo.option.ConnectionPassword", pass);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", driverName);
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("sentry.javax.jdo") && !key.startsWith("sentry.datanucleus")) continue;
            key = StringUtils.removeStart((String)key, (String)"sentry.");
            prop.setProperty(key, (String)entry.getValue());
        }
        boolean checkSchemaVersion = conf.get("sentry.verify.schema.version", "true").equalsIgnoreCase("true");
        if (!checkSchemaVersion) {
            prop.setProperty("datanucleus.autoCreateSchema", "true");
            prop.setProperty("datanucleus.fixedDatastore", "false");
        }
        prop.setProperty("datanucleus.NontransactionalRead", "false");
        prop.setProperty("datanucleus.NontransactionalWrite", "false");
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        this.verifySentryStoreSchema(conf, checkSchemaVersion);
        this.privCleaner = new PrivCleaner();
        if (conf.get("sentry.store.orphaned.privilege.removal", "false").equalsIgnoreCase("true")) {
            this.privCleanerThread = new Thread(this.privCleaner);
            this.privCleanerThread.start();
        }
    }

    private void verifySentryStoreSchema(Configuration serverConf, boolean checkVersion) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        if (!checkVersion) {
            this.setSentryVersion(SentryStoreSchemaInfo.getSentryVersion(), "Schema version set implicitly");
        } else {
            String currentVersion = this.getSentryVersion();
            if (!SentryStoreSchemaInfo.getSentryVersion().equals(currentVersion)) {
                throw new SentryAccessDeniedException("The Sentry store schema version " + currentVersion + " is different from distribution version " + SentryStoreSchemaInfo.getSentryVersion());
            }
        }
    }

    public synchronized void stop() {
        if (this.privCleanerThread != null) {
            this.privCleaner.exit();
            try {
                this.privCleanerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.pmf != null) {
            this.pmf.close();
        }
    }

    public synchronized PersistenceManager openTransaction() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction currentTransaction = pm.currentTransaction();
        currentTransaction.begin();
        return pm;
    }

    public synchronized CommitContext commitUpdateTransaction(PersistenceManager pm) {
        this.commitTransaction(pm);
        return new CommitContext(SERVER_UUID, this.incrementGetSequenceId());
    }

    private synchronized long incrementGetSequenceId() {
        return ++this.commitSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(PersistenceManager pm) {
        Transaction currentTransaction = pm.currentTransaction();
        try {
            Preconditions.checkState((boolean)currentTransaction.isActive(), (Object)"Transaction is not active");
            currentTransaction.commit();
        }
        finally {
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(PersistenceManager pm) {
        if (pm == null || pm.isClosed()) {
            return;
        }
        Transaction currentTransaction = pm.currentTransaction();
        if (currentTransaction.isActive()) {
            try {
                currentTransaction.rollback();
            }
            finally {
                pm.close();
            }
        }
    }

    public MSentryRole getMSentryRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
        return sentryRole;
    }

    private String trimAndLower(String input) {
        return input.trim().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext createSentryRole(String roleName) throws SentryAlreadyExistsException {
        roleName = this.trimAndLower(roleName);
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            this.createSentryRoleCore(pm, roleName);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void createSentryRoleCore(PersistenceManager pm, String roleName) throws SentryAlreadyExistsException {
        MSentryRole mSentryRole = this.getMSentryRole(pm, roleName);
        if (mSentryRole != null) {
            throw new SentryAlreadyExistsException("Role: " + roleName);
        }
        MSentryRole mRole = new MSentryRole(roleName, System.currentTimeMillis());
        pm.makePersistent((Object)mRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Long getCount(Class<T> tClass) {
        PersistenceManager pm = null;
        Long size = new Long(-1L);
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery();
            query.setClass(tClass);
            query.setResult("count(this)");
            size = (Long)query.execute();
        }
        finally {
            this.commitTransaction(pm);
        }
        return size;
    }

    public Gauge<Long> getRoleCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryRole.class);
            }
        };
    }

    public Gauge<Long> getPrivilegeCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryPrivilege.class);
            }
        };
    }

    public Gauge<Long> getGroupCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryGroup.class);
            }
        };
    }

    @VisibleForTesting
    long countMSentryPrivileges() {
        return this.getCount(MSentryPrivilege.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void clearAllTables() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            pm.newQuery(MSentryRole.class).deletePersistentAll();
            pm.newQuery(MSentryGroup.class).deletePersistentAll();
            pm.newQuery(MSentryPrivilege.class).deletePersistentAll();
            this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public CommitContext alterSentryRoleGrantPrivilege(String grantorPrincipal, String roleName, TSentryPrivilege privilege) throws SentryUserException {
        return this.alterSentryRoleGrantPrivileges(grantorPrincipal, roleName, Sets.newHashSet((Object[])new TSentryPrivilege[]{privilege}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleGrantPrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> privileges) throws SentryUserException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = this.trimAndLower(roleName);
        try {
            pm = this.openTransaction();
            for (TSentryPrivilege privilege : privileges) {
                this.grantOptionCheck(pm, grantorPrincipal, privilege);
                MSentryPrivilege mPrivilege = this.alterSentryRoleGrantPrivilegeCore(pm, roleName, privilege);
                if (mPrivilege == null) continue;
                this.convertToTSentryPrivilege(mPrivilege, privilege);
            }
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryPrivilege alterSentryRoleGrantPrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        MSentryPrivilege mPrivilege = null;
        MSentryRole mRole = this.getMSentryRole(pm, roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        if (!(SentryStore.isNULL(privilege.getColumnName()) && SentryStore.isNULL(privilege.getTableName()) && SentryStore.isNULL(privilege.getDbName()))) {
            if ("*".equalsIgnoreCase(privilege.getAction()) || "ALL".equalsIgnoreCase(privilege.getAction())) {
                TSentryPrivilege tNotAll = new TSentryPrivilege(privilege);
                tNotAll.setAction("select");
                MSentryPrivilege mSelect = this.getMSentryPrivilege(tNotAll, pm);
                tNotAll.setAction("insert");
                MSentryPrivilege mInsert = this.getMSentryPrivilege(tNotAll, pm);
                if (mSelect != null && mRole.getPrivileges().contains(mSelect)) {
                    mSelect.removeRole(mRole);
                    this.privCleaner.incPrivRemoval();
                    pm.makePersistent((Object)mSelect);
                }
                if (mInsert != null && mRole.getPrivileges().contains(mInsert)) {
                    mInsert.removeRole(mRole);
                    this.privCleaner.incPrivRemoval();
                    pm.makePersistent((Object)mInsert);
                }
            } else {
                TSentryPrivilege tAll = new TSentryPrivilege(privilege);
                tAll.setAction("*");
                MSentryPrivilege mAll1 = this.getMSentryPrivilege(tAll, pm);
                tAll.setAction("ALL");
                MSentryPrivilege mAll2 = this.getMSentryPrivilege(tAll, pm);
                if (mAll1 != null && mRole.getPrivileges().contains(mAll1)) {
                    return null;
                }
                if (mAll2 != null && mRole.getPrivileges().contains(mAll2)) {
                    return null;
                }
            }
        }
        if ((mPrivilege = this.getMSentryPrivilege(privilege, pm)) == null) {
            mPrivilege = this.convertToMSentryPrivilege(privilege);
        }
        mPrivilege.appendRole(mRole);
        pm.makePersistent((Object)mRole);
        pm.makePersistent((Object)mPrivilege);
        return mPrivilege;
    }

    public CommitContext alterSentryRoleRevokePrivilege(String grantorPrincipal, String roleName, TSentryPrivilege tPrivilege) throws SentryUserException {
        return this.alterSentryRoleRevokePrivileges(grantorPrincipal, roleName, Sets.newHashSet((Object[])new TSentryPrivilege[]{tPrivilege}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleRevokePrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> tPrivileges) throws SentryUserException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = SentryStore.safeTrimLower(roleName);
        try {
            pm = this.openTransaction();
            for (TSentryPrivilege tPrivilege : tPrivileges) {
                this.grantOptionCheck(pm, grantorPrincipal, tPrivilege);
                this.alterSentryRoleRevokePrivilegeCore(pm, roleName, tPrivilege);
            }
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void alterSentryRoleRevokePrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole mRole = (MSentryRole)query.execute((Object)roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        query = pm.newQuery(MSentryPrivilege.class);
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege, pm);
        mPrivilege = mPrivilege == null ? this.convertToMSentryPrivilege(tPrivilege) : (MSentryPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet privilegeGraph = Sets.newHashSet();
        if (mPrivilege.getGrantOption() != null) {
            privilegeGraph.add(mPrivilege);
        } else {
            MSentryPrivilege mTure = new MSentryPrivilege(mPrivilege);
            mTure.setGrantOption(true);
            privilegeGraph.add(mTure);
            MSentryPrivilege mFalse = new MSentryPrivilege(mPrivilege);
            mFalse.setGrantOption(false);
            privilegeGraph.add(mFalse);
        }
        this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{roleName}), mPrivilege, privilegeGraph);
        for (MSentryPrivilege childPriv : privilegeGraph) {
            this.revokePrivilegeFromRole(pm, tPrivilege, mRole, childPriv);
        }
        pm.makePersistent((Object)mRole);
    }

    private void revokePartial(PersistenceManager pm, TSentryPrivilege requestedPrivToRevoke, MSentryRole mRole, MSentryPrivilege currentPrivilege) throws SentryInvalidInputException {
        MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv == null) {
            persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
        }
        if (requestedPrivToRevoke.getAction().equalsIgnoreCase("ALL") || requestedPrivToRevoke.getAction().equalsIgnoreCase("*")) {
            persistedPriv.removeRole(mRole);
            this.privCleaner.incPrivRemoval();
            pm.makePersistent((Object)persistedPriv);
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("select") && !currentPrivilege.getAction().equalsIgnoreCase("insert")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "insert");
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("insert") && !currentPrivilege.getAction().equalsIgnoreCase("select")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "select");
        }
    }

    private void revokeRolePartial(PersistenceManager pm, MSentryRole mRole, MSentryPrivilege currentPrivilege, MSentryPrivilege persistedPriv, String addAction) throws SentryInvalidInputException {
        persistedPriv.removeRole(mRole);
        this.privCleaner.incPrivRemoval();
        pm.makePersistent((Object)persistedPriv);
        currentPrivilege.setAction("*");
        persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv != null && mRole.getPrivileges().contains(persistedPriv)) {
            persistedPriv.removeRole(mRole);
            this.privCleaner.incPrivRemoval();
            pm.makePersistent((Object)persistedPriv);
            currentPrivilege.setAction(addAction);
            persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
            if (persistedPriv == null) {
                persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
                mRole.appendPrivilege(persistedPriv);
            }
            persistedPriv.appendRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    private void revokePrivilegeFromRole(PersistenceManager pm, TSentryPrivilege tPrivilege, MSentryRole mRole, MSentryPrivilege mPrivilege) throws SentryInvalidInputException {
        if (PARTIAL_REVOKE_ACTIONS.contains(mPrivilege.getAction())) {
            this.revokePartial(pm, tPrivilege, mRole, mPrivilege);
        } else {
            MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(mPrivilege), pm);
            if (persistedPriv != null) {
                mPrivilege.removeRole(mRole);
                this.privCleaner.incPrivRemoval();
                pm.makePersistent((Object)mPrivilege);
            }
        }
    }

    private void populateChildren(PersistenceManager pm, Set<String> roleNames, MSentryPrivilege priv, Set<MSentryPrivilege> children) throws SentryInvalidInputException {
        Preconditions.checkNotNull((Object)pm);
        if (!(SentryStore.isNULL(priv.getServerName()) && SentryStore.isNULL(priv.getDbName()) && SentryStore.isNULL(priv.getTableName()))) {
            Set<MSentryPrivilege> childPrivs = this.getChildPrivileges(pm, roleNames, priv);
            for (MSentryPrivilege childPriv : childPrivs) {
                if (!(SentryStore.isNULL(childPriv.getDbName()) || SentryStore.isNULL(childPriv.getTableName()) || SentryStore.isNULL(childPriv.getColumnName()))) {
                    this.populateChildren(pm, roleNames, childPriv, children);
                }
                if (!priv.isActionALL()) {
                    if (childPriv.isActionALL()) {
                        childPriv.setAction(priv.getAction());
                    }
                    if (!priv.implies(childPriv)) continue;
                }
                children.add(childPriv);
            }
        }
    }

    private Set<MSentryPrivilege> getChildPrivileges(PersistenceManager pm, Set<String> roleNames, MSentryPrivilege parent) throws SentryInvalidInputException {
        if (!SentryStore.isNULL(parent.getColumnName()) || !SentryStore.isNULL(parent.getURI())) {
            return new HashSet<MSentryPrivilege>();
        }
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
        LinkedList<String> rolesFiler = new LinkedList<String>();
        for (String rName : roleNames) {
            rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
        }
        StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
        filters.append(" && serverName == \"" + parent.getServerName() + "\"");
        if (!SentryStore.isNULL(parent.getDbName())) {
            filters.append(" && dbName == \"" + parent.getDbName() + "\"");
            if (!SentryStore.isNULL(parent.getTableName())) {
                filters.append(" && tableName == \"" + parent.getTableName() + "\"");
                filters.append(" && columnName != \"__NULL__\"");
            } else {
                filters.append(" && tableName != \"__NULL__\"");
            }
        } else {
            filters.append(" && (dbName != \"__NULL__\" || URI != \"__NULL__\")");
        }
        query.setFilter(filters.toString());
        query.setResult("privilegeScope, serverName, dbName, tableName, columnName, URI, action, grantOption");
        HashSet<MSentryPrivilege> privileges = new HashSet<MSentryPrivilege>();
        for (Object[] privObj : (List)query.execute()) {
            MSentryPrivilege priv = new MSentryPrivilege();
            priv.setPrivilegeScope((String)privObj[0]);
            priv.setServerName((String)privObj[1]);
            priv.setDbName((String)privObj[2]);
            priv.setTableName((String)privObj[3]);
            priv.setColumnName((String)privObj[4]);
            priv.setURI((String)privObj[5]);
            priv.setAction((String)privObj[6]);
            priv.setGrantOption((Boolean)privObj[7]);
            privileges.add(priv);
        }
        return privileges;
    }

    private List<MSentryPrivilege> getMSentryPrivileges(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        StringBuilder filters = new StringBuilder("this.serverName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getServerName())) + "\" ");
        if (!SentryStore.isNULL(tPriv.getDbName())) {
            filters.append("&& this.dbName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getDbName())) + "\" ");
            if (!SentryStore.isNULL(tPriv.getTableName())) {
                filters.append("&& this.tableName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getTableName())) + "\" ");
                if (!SentryStore.isNULL(tPriv.getColumnName())) {
                    filters.append("&& this.columnName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getColumnName())) + "\" ");
                }
            }
        } else if (!SentryStore.isNULL(tPriv.getURI())) {
            filters.append("&& this.URI == \"" + SentryStore.toNULLCol(SentryStore.safeTrim(tPriv.getURI())) + "\" ");
        }
        filters.append("&& this.action == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getAction())) + "\"");
        query.setFilter(filters.toString());
        List privileges = (List)query.execute();
        return privileges;
    }

    private MSentryPrivilege getMSentryPrivilege(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.setFilter("this.serverName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getServerName())) + "\" " + "&& this.dbName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getDbName())) + "\" " + "&& this.tableName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getTableName())) + "\" " + "&& this.columnName == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getColumnName())) + "\" " + "&& this.URI == \"" + SentryStore.toNULLCol(SentryStore.safeTrim(tPriv.getURI())) + "\" " + "&& this.grantOption == grantOption " + "&& this.action == \"" + SentryStore.toNULLCol(SentryStore.safeTrimLower(tPriv.getAction())) + "\"");
        query.declareParameters("Boolean grantOption");
        query.setUnique(true);
        Boolean grantOption = null;
        if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.TRUE)) {
            grantOption = true;
        } else if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.FALSE)) {
            grantOption = false;
        }
        Object obj = query.execute((Object)grantOption);
        if (obj != null) {
            return (MSentryPrivilege)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext dropSentryRole(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            this.dropSentryRoleCore(pm, roleName);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void dropSentryRoleCore(PersistenceManager pm, String roleName) throws SentryNoSuchObjectException {
        String lRoleName = roleName.trim().toLowerCase();
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole sentryRole = (MSentryRole)query.execute((Object)lRoleName);
        if (sentryRole == null) {
            throw new SentryNoSuchObjectException("Role " + lRoleName);
        }
        pm.retrieve((Object)sentryRole);
        int numPrivs = sentryRole.getPrivileges().size();
        sentryRole.removePrivileges();
        sentryRole.removeGMPrivileges();
        this.privCleaner.incPrivRemoval(numPrivs);
        pm.deletePersistent((Object)sentryRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleAddGroups(String grantorPrincipal, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            this.alterSentryRoleAddGroupsCore(pm, roleName, groupNames);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void alterSentryRoleAddGroupsCore(PersistenceManager pm, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        String lRoleName = roleName.trim().toLowerCase();
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole role = (MSentryRole)query.execute((Object)lRoleName);
        if (role == null) {
            throw new SentryNoSuchObjectException("Role: " + lRoleName);
        }
        query = pm.newQuery(MSentryGroup.class);
        query.setFilter("this.groupName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        ArrayList groups = Lists.newArrayList();
        for (TSentryGroup tGroup : groupNames) {
            String groupName = tGroup.getGroupName().trim();
            MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
            if (group == null) {
                group = new MSentryGroup(groupName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
            }
            group.appendRole(role);
            groups.add(group);
        }
        pm.makePersistentAll((Collection)groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleDeleteGroups(String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole role = (MSentryRole)query.execute((Object)roleName);
            if (role == null) {
                throw new SentryNoSuchObjectException("Role: " + roleName);
            }
            query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) continue;
                group.removeRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    MSentryRole getMSentryRoleByName(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + roleName);
            }
            pm.retrieve((Object)sentryRole);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            MSentryRole mSentryRole = sentryRole;
            return mSentryRole;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnyServerPrivileges(Set<String> roleNames, String serverName) {
        if (roleNames.size() == 0 || roleNames == null) {
            return false;
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            filters.append("&& serverName == \"" + serverName.trim().toLowerCase() + "\"");
            query.setFilter(filters.toString());
            query.setResult("count(this)");
            Long numPrivs = (Long)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            boolean bl = numPrivs > 0L;
            return bl;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MSentryPrivilege> getMSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) {
        if (roleNames.size() == 0 || roleNames == null) {
            return new ArrayList<MSentryPrivilege>();
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            if (authHierarchy != null && authHierarchy.getServer() != null) {
                filters.append("&& serverName == \"" + authHierarchy.getServer().toLowerCase() + "\"");
                if (authHierarchy.getDb() != null) {
                    filters.append(" && ((dbName == \"" + authHierarchy.getDb().toLowerCase() + "\") || (dbName == \"__NULL__\")) && (URI == \"__NULL__\")");
                    if (authHierarchy.getTable() != null && !"*".equalsIgnoreCase(authHierarchy.getTable())) {
                        filters.append(" && ((tableName == \"" + authHierarchy.getTable().toLowerCase() + "\") || (tableName == \"__NULL__\")) && (URI == \"__NULL__\")");
                        if (authHierarchy.getColumn() != null && !"*".equalsIgnoreCase(authHierarchy.getColumn())) {
                            filters.append(" && ((columnName == \"" + authHierarchy.getColumn().toLowerCase() + "\") || (columnName == \"__NULL__\")) && (URI == \"__NULL__\")");
                        }
                    }
                }
                if (authHierarchy.getUri() != null) {
                    filters.append(" && ((URI != \"__NULL__\") && (\"" + authHierarchy.getUri() + "\".startsWith(URI)) || (URI == \"__NULL__\")) && (dbName == \"__NULL__\")");
                }
            }
            query.setFilter(filters.toString());
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            List list = privileges;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MSentryPrivilege> getMSentryPrivilegesByAuth(Set<String> roleNames, TSentryAuthorizable authHierarchy) {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            LinkedList<MSentryPrivilege> rolesFiler;
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            StringBuilder filters = new StringBuilder();
            if (roleNames.size() == 0 || roleNames == null) {
                filters.append(" !roles.isEmpty() ");
            } else {
                query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
                rolesFiler = new LinkedList();
                for (String rName : roleNames) {
                    rolesFiler.add((MSentryPrivilege)((Object)("role.roleName == \"" + rName.trim().toLowerCase() + "\"")));
                }
                filters.append("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            }
            if (authHierarchy.getServer() != null) {
                filters.append("&& serverName == \"" + authHierarchy.getServer().toLowerCase() + "\"");
                if (authHierarchy.getDb() != null) {
                    filters.append(" && (dbName == \"" + authHierarchy.getDb().toLowerCase() + "\") && (URI == \"__NULL__\")");
                    if (authHierarchy.getTable() != null) {
                        filters.append(" && (tableName == \"" + authHierarchy.getTable().toLowerCase() + "\")");
                    } else {
                        filters.append(" && (tableName == \"__NULL__\")");
                    }
                } else if (authHierarchy.getUri() != null) {
                    filters.append(" && (URI != \"__NULL__\") && (\"" + authHierarchy.getUri() + "\".startsWith(URI)) && (dbName == \"__NULL__\")");
                } else {
                    filters.append(" && (dbName == \"__NULL__\") && (URI == \"__NULL__\")");
                }
            } else {
                rolesFiler = new ArrayList();
                return rolesFiler;
            }
            FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRole");
            grp.addMember("roles");
            pm.getFetchPlan().addGroup("fetchRole");
            query.setFilter(filters.toString());
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            List list = privileges;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizable(Set<String> groups, TSentryActiveRoleSet activeRoles, TSentryAuthorizable authHierarchy, boolean isAdmin) throws SentryInvalidInputException {
        TreeMap resultPrivilegeMap = Maps.newTreeMap();
        Set<Object> roles = Sets.newHashSet();
        if (groups != null && !groups.isEmpty()) {
            roles = this.getRolesToQuery(groups, new TSentryActiveRoleSet(true, null));
        }
        if (activeRoles != null && !activeRoles.isAll()) {
            for (String aRole : activeRoles.getRoles()) {
                roles.add(aRole.toLowerCase());
            }
        }
        if (isAdmin || !roles.isEmpty()) {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivilegesByAuth((Set<String>)roles, authHierarchy);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (MSentryRole role : priv.getRoles()) {
                    TSentryPrivilege tPriv = this.convertToTSentryPrivilege(priv);
                    if (resultPrivilegeMap.containsKey(role.getRoleName())) {
                        ((Set)resultPrivilegeMap.get(role.getRoleName())).add(tPriv);
                        continue;
                    }
                    TreeSet tPrivSet = Sets.newTreeSet();
                    tPrivSet.add(tPriv);
                    resultPrivilegeMap.put(role.getRoleName(), tPrivSet);
                }
            }
        }
        return new TSentryPrivilegeMap(resultPrivilegeMap);
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        MSentryRole mSentryRole = this.getMSentryRoleByName(roleName);
        return mSentryRole.getPrivileges();
    }

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByRoleName(roleName));
    }

    public Set<TSentryPrivilege> getTSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        if (authHierarchy.getServer() == null) {
            throw new SentryInvalidInputException("serverName cannot be null !!");
        }
        if (authHierarchy.getTable() != null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("dbName cannot be null when tableName is present !!");
        }
        if (authHierarchy.getColumn() != null && authHierarchy.getTable() == null) {
            throw new SentryInvalidInputException("tableName cannot be null when columnName is present !!");
        }
        if (authHierarchy.getUri() == null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("One of uri or dbName must not be null !!");
        }
        return this.convertToTSentryPrivileges(this.getMSentryPrivileges(roleNames, authHierarchy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MSentryRole> getMSentryRolesByGroupName(String groupName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            Set<MSentryRole> roles;
            Query query;
            pm = this.openTransaction();
            if (groupName == null) {
                query = pm.newQuery(MSentryRole.class);
                roles = new HashSet<MSentryRole>((List)query.execute());
            } else {
                query = pm.newQuery(MSentryGroup.class);
                groupName = groupName.trim();
                query.setFilter("this.groupName == t");
                query.declareParameters("java.lang.String t");
                query.setUnique(true);
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)groupName);
                if (sentryGroup == null) {
                    throw new SentryNoSuchObjectException("Group " + groupName);
                }
                pm.retrieve((Object)sentryGroup);
                roles = sentryGroup.getRoles();
            }
            for (MSentryRole role : roles) {
                pm.retrieve((Object)role);
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashSet<MSentryRole> hashSet = roles;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public Set<TSentryRole> getTSentryRolesByGroupName(Set<String> groupNames, boolean checkAllGroups) throws SentryNoSuchObjectException {
        HashSet roleSet = Sets.newHashSet();
        for (String groupName : groupNames) {
            try {
                roleSet.addAll(this.getMSentryRolesByGroupName(groupName));
            }
            catch (SentryNoSuchObjectException e) {
                if (checkAllGroups) continue;
                throw e;
            }
        }
        return this.convertToTSentryRoles(roleSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRoleNamesForGroups(Set<String> groups) {
        HashSet<String> result = new HashSet<String>();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            for (String group : groups) {
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
                if (sentryGroup == null) continue;
                for (MSentryRole role : sentryGroup.getRoles()) {
                    result.add(role.getRoleName());
                }
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public Set<MSentryRole> getRolesForGroups(PersistenceManager pm, Set<String> groups) {
        HashSet<MSentryRole> result = new HashSet<MSentryRole>();
        Query query = pm.newQuery(MSentryGroup.class);
        query.setFilter("this.groupName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        for (String group : groups) {
            MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
            if (sentryGroup == null) continue;
            result.addAll(sentryGroup.getRoles());
        }
        return result;
    }

    public Set<String> listAllSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet) throws SentryInvalidInputException {
        return this.listSentryPrivilegesForProvider(groups, roleSet, null);
    }

    public Set<String> listSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        HashSet result = Sets.newHashSet();
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivileges(rolesToQuery, authHierarchy);
        for (MSentryPrivilege priv : mSentryPrivileges) {
            result.add(SentryStore.toAuthorizable(priv));
        }
        return result;
    }

    public boolean hasAnyServerPrivileges(Set<String> groups, TSentryActiveRoleSet roleSet, String server) {
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        return this.hasAnyServerPrivileges(rolesToQuery, server);
    }

    private Set<String> getRolesToQuery(Set<String> groups, TSentryActiveRoleSet roleSet) {
        Set<String> activeRoleNames = SentryStore.toTrimedLower(roleSet.getRoles());
        Sets.SetView roleNamesForGroups = SentryStore.toTrimedLower(this.getRoleNamesForGroups(groups));
        Sets.SetView rolesToQuery = roleSet.isAll() ? roleNamesForGroups : Sets.intersection(activeRoleNames, roleNamesForGroups);
        return rolesToQuery;
    }

    @VisibleForTesting
    static String toAuthorizable(MSentryPrivilege privilege) {
        ArrayList<String> authorizable = new ArrayList<String>(4);
        authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), (Object)privilege.getServerName(), new Object[0]));
        if (SentryStore.isNULL(privilege.getURI())) {
            if (!SentryStore.isNULL(privilege.getDbName())) {
                authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), (Object)privilege.getDbName(), new Object[0]));
                if (!SentryStore.isNULL(privilege.getTableName())) {
                    authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), (Object)privilege.getTableName(), new Object[0]));
                    if (!SentryStore.isNULL(privilege.getColumnName())) {
                        authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Column.name().toLowerCase(), (Object)privilege.getColumnName(), new Object[0]));
                    }
                }
            }
        } else {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), (Object)privilege.getURI(), new Object[0]));
        }
        if (!SentryStore.isNULL(privilege.getAction()) && !privilege.getAction().equalsIgnoreCase("*")) {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)"action".toLowerCase(), (Object)privilege.getAction(), new Object[0]));
        }
        return ProviderConstants.AUTHORIZABLE_JOINER.join(authorizable);
    }

    @VisibleForTesting
    static Set<String> toTrimedLower(Set<String> s) {
        if (null == s) {
            return new HashSet<String>();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<TSentryPrivilege> convertToTSentryPrivileges(Collection<MSentryPrivilege> mSentryPrivileges) {
        HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>();
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            privileges.add(this.convertToTSentryPrivilege(mSentryPrivilege));
        }
        return privileges;
    }

    private Set<TSentryRole> convertToTSentryRoles(Set<MSentryRole> mSentryRoles) {
        HashSet<TSentryRole> roles = new HashSet<TSentryRole>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            roles.add(this.convertToTSentryRole(mSentryRole));
        }
        return roles;
    }

    private TSentryRole convertToTSentryRole(MSentryRole mSentryRole) {
        TSentryRole role = new TSentryRole();
        role.setRoleName(mSentryRole.getRoleName());
        role.setGrantorPrincipal("--");
        HashSet<TSentryGroup> sentryGroups = new HashSet<TSentryGroup>();
        for (MSentryGroup mSentryGroup : mSentryRole.getGroups()) {
            TSentryGroup group = this.convertToTSentryGroup(mSentryGroup);
            sentryGroups.add(group);
        }
        role.setGroups(sentryGroups);
        return role;
    }

    private TSentryGroup convertToTSentryGroup(MSentryGroup mSentryGroup) {
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(mSentryGroup.getGroupName());
        return group;
    }

    protected TSentryPrivilege convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        this.convertToTSentryPrivilege(mSentryPrivilege, privilege);
        return privilege;
    }

    private void convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege, TSentryPrivilege privilege) {
        privilege.setCreateTime(mSentryPrivilege.getCreateTime());
        privilege.setAction(SentryStore.fromNULLCol(mSentryPrivilege.getAction()));
        privilege.setPrivilegeScope(mSentryPrivilege.getPrivilegeScope());
        privilege.setServerName(SentryStore.fromNULLCol(mSentryPrivilege.getServerName()));
        privilege.setDbName(SentryStore.fromNULLCol(mSentryPrivilege.getDbName()));
        privilege.setTableName(SentryStore.fromNULLCol(mSentryPrivilege.getTableName()));
        privilege.setColumnName(SentryStore.fromNULLCol(mSentryPrivilege.getColumnName()));
        privilege.setURI(SentryStore.fromNULLCol(mSentryPrivilege.getURI()));
        if (mSentryPrivilege.getGrantOption() != null) {
            privilege.setGrantOption(TSentryGrantOption.valueOf(mSentryPrivilege.getGrantOption().toString().toUpperCase()));
        } else {
            privilege.setGrantOption(TSentryGrantOption.UNSET);
        }
    }

    private MSentryPrivilege convertToMSentryPrivilege(TSentryPrivilege privilege) throws SentryInvalidInputException {
        MSentryPrivilege mSentryPrivilege = new MSentryPrivilege();
        mSentryPrivilege.setServerName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getServerName())));
        mSentryPrivilege.setDbName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getDbName())));
        mSentryPrivilege.setTableName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getTableName())));
        mSentryPrivilege.setColumnName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getColumnName())));
        mSentryPrivilege.setPrivilegeScope(SentryStore.safeTrim(privilege.getPrivilegeScope()));
        mSentryPrivilege.setAction(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getAction())));
        mSentryPrivilege.setCreateTime(System.currentTimeMillis());
        mSentryPrivilege.setURI(SentryStore.toNULLCol(SentryStore.safeTrim(privilege.getURI())));
        if (!privilege.getGrantOption().equals((Object)TSentryGrantOption.UNSET)) {
            mSentryPrivilege.setGrantOption(Boolean.valueOf(privilege.getGrantOption().toString()));
        } else {
            mSentryPrivilege.setGrantOption(null);
        }
        return mSentryPrivilege;
    }

    private static String safeTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private static String safeTrimLower(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toLowerCase();
    }

    public String getSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion = this.getMSentryVersion();
        return mVersion.getSchemaVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSentryVersion(String newVersion, String verComment) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion;
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            mVersion = this.getMSentryVersion();
            if (newVersion.equals(mVersion.getSchemaVersion())) {
                return;
            }
        }
        catch (SentryNoSuchObjectException e) {
            mVersion = new MSentryVersion();
        }
        mVersion.setSchemaVersion(newVersion);
        mVersion.setVersionComment(verComment);
        try {
            pm = this.openTransaction();
            pm.makePersistent((Object)mVersion);
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryVersion getMSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryVersion.class);
            List mSentryVersions = (List)query.execute();
            pm.retrieveAll((Collection)mSentryVersions);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            if (mSentryVersions.isEmpty()) {
                throw new SentryNoSuchObjectException("No matching version found");
            }
            if (mSentryVersions.size() > 1) {
                throw new SentryAccessDeniedException("Metastore contains multiple versions");
            }
            MSentryVersion mSentryVersion = (MSentryVersion)mSentryVersions.get(0);
            return mSentryVersion;
        }
        catch (JDODataStoreException e) {
            if (e.getCause() instanceof MissingTableException) {
                throw new SentryAccessDeniedException("Version table not found. The sentry store is not set or corrupt ");
            }
            throw e;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void dropPrivilege(TSentryAuthorizable tAuthorizable) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : ALL_ACTIONS) {
                    tPrivilege.setAction(privilegeAction);
                    this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                }
            } else {
                this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void renamePrivilege(TSentryAuthorizable tAuthorizable, TSentryAuthorizable newTAuthorizable) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        TSentryPrivilege newPrivilege = this.toSentryPrivilege(newTAuthorizable);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : ALL_ACTIONS) {
                    tPrivilege.setAction(privilegeAction);
                    newPrivilege.setAction(privilegeAction);
                    this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                }
            } else {
                this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private boolean isMultiActionsSupported(TSentryPrivilege tPrivilege) {
        return tPrivilege.getDbName() != null;
    }

    private void renamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
    }

    private void dropPrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, null);
    }

    private void dropOrRenamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newTPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        HashSet roleSet = Sets.newHashSet();
        List<MSentryPrivilege> mPrivileges = this.getMSentryPrivileges(tPrivilege, pm);
        if (mPrivileges != null && !mPrivileges.isEmpty()) {
            for (MSentryPrivilege mPrivilege : mPrivileges) {
                roleSet.addAll(ImmutableSet.copyOf(mPrivilege.getRoles()));
            }
        }
        MSentryPrivilege parent = this.getMSentryPrivilege(tPrivilege, pm);
        for (MSentryRole role : roleSet) {
            HashSet privilegeGraph = Sets.newHashSet();
            if (parent != null) {
                privilegeGraph.add(parent);
                this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{role.getRoleName()}), parent, privilegeGraph);
            } else {
                this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{role.getRoleName()}), this.convertToMSentryPrivilege(tPrivilege), privilegeGraph);
            }
            this.alterSentryRoleRevokePrivilegeCore(pm, role.getRoleName(), tPrivilege);
            if (newTPrivilege == null) continue;
            for (MSentryPrivilege m : privilegeGraph) {
                TSentryPrivilege t = this.convertToTSentryPrivilege(m);
                if (newTPrivilege.getPrivilegeScope().equals(ServiceConstants.PrivilegeScope.DATABASE.name())) {
                    t.setDbName(newTPrivilege.getDbName());
                } else if (newTPrivilege.getPrivilegeScope().equals(ServiceConstants.PrivilegeScope.TABLE.name())) {
                    t.setTableName(newTPrivilege.getTableName());
                }
                this.alterSentryRoleGrantPrivilegeCore(pm, role.getRoleName(), t);
            }
        }
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable) throws SentryInvalidInputException {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setDbName(SentryStore.fromNULLCol(tAuthorizable.getDb()));
        tSentryPrivilege.setServerName(SentryStore.fromNULLCol(tAuthorizable.getServer()));
        tSentryPrivilege.setTableName(SentryStore.fromNULLCol(tAuthorizable.getTable()));
        tSentryPrivilege.setColumnName(SentryStore.fromNULLCol(tAuthorizable.getColumn()));
        tSentryPrivilege.setURI(SentryStore.fromNULLCol(tAuthorizable.getUri()));
        ServiceConstants.PrivilegeScope scope = !SentryStore.isNULL(tSentryPrivilege.getColumnName()) ? ServiceConstants.PrivilegeScope.COLUMN : (!SentryStore.isNULL(tSentryPrivilege.getTableName()) ? ServiceConstants.PrivilegeScope.TABLE : (!SentryStore.isNULL(tSentryPrivilege.getDbName()) ? ServiceConstants.PrivilegeScope.DATABASE : (!SentryStore.isNULL(tSentryPrivilege.getURI()) ? ServiceConstants.PrivilegeScope.URI : ServiceConstants.PrivilegeScope.SERVER)));
        tSentryPrivilege.setPrivilegeScope(scope.name());
        tSentryPrivilege.setAction("*");
        return tSentryPrivilege;
    }

    public static String toNULLCol(String s) {
        return Strings.isNullOrEmpty((String)s) ? NULL_COL : s;
    }

    public static String fromNULLCol(String s) {
        return SentryStore.isNULL(s) ? "" : s;
    }

    public static boolean isNULL(String s) {
        return Strings.isNullOrEmpty((String)s) || s.equals(NULL_COL);
    }

    private void grantOptionCheck(PersistenceManager pm, String grantorPrincipal, TSentryPrivilege privilege) throws SentryUserException {
        MSentryPrivilege mPrivilege = this.convertToMSentryPrivilege(privilege);
        if (grantorPrincipal == null) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null");
        }
        Set<String> groups = SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, grantorPrincipal);
        if (groups == null || groups.isEmpty()) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
        Set<String> admins = this.getAdminGroups();
        boolean isAdminGroup = false;
        if (admins != null && !admins.isEmpty()) {
            for (String g : groups) {
                if (!admins.contains(g)) continue;
                isAdminGroup = true;
                break;
            }
        }
        if (!isAdminGroup) {
            boolean hasGrant = false;
            Set<MSentryRole> roles = this.getRolesForGroups(pm, groups);
            if (roles != null && !roles.isEmpty()) {
                block1: for (MSentryRole role : roles) {
                    Set<MSentryPrivilege> privilegeSet = role.getPrivileges();
                    if (privilegeSet == null || privilegeSet.isEmpty()) continue;
                    for (MSentryPrivilege p : privilegeSet) {
                        if (!p.getGrantOption().booleanValue() || !p.implies(mPrivilege)) continue;
                        hasGrant = true;
                        continue block1;
                    }
                }
            }
            if (!hasGrant) {
                throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
            }
        }
    }

    private Set<String> getAdminGroups() {
        return Sets.newHashSet((Object[])this.conf.getStrings("sentry.service.admin.group", new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HashMap<String, String>> retrieveFullPrivilegeImage() {
        HashMap<String, HashMap<String, String>> retVal = new HashMap<String, HashMap<String, String>>();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            String filters = "(serverName != \"__NULL__\") && (dbName != \"__NULL__\") && (URI == \"__NULL__\")";
            query.setFilter(filters.toString());
            query.setOrdering("serverName ascending, dbName ascending, tableName ascending");
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            for (MSentryPrivilege mPriv : privileges) {
                HashMap<String, String> pUpdate;
                String authzObj = mPriv.getDbName();
                if (!SentryStore.isNULL(mPriv.getTableName())) {
                    authzObj = authzObj + "." + mPriv.getTableName();
                }
                if ((pUpdate = (HashMap<String, String>)retVal.get(authzObj)) == null) {
                    pUpdate = new HashMap<String, String>();
                    retVal.put(authzObj, pUpdate);
                }
                for (MSentryRole mRole : mPriv.getRoles()) {
                    String existingPriv = (String)pUpdate.get(mRole.getRoleName());
                    if (existingPriv == null) {
                        pUpdate.put(mRole.getRoleName(), mPriv.getAction().toUpperCase());
                        continue;
                    }
                    pUpdate.put(mRole.getRoleName(), existingPriv + "," + mPriv.getAction().toUpperCase());
                }
            }
            this.commitTransaction(pm);
            HashMap<String, HashMap<String, String>> hashMap = retVal;
            return hashMap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LinkedList<String>> retrieveFullRoleImage() {
        HashMap<String, LinkedList<String>> retVal = new HashMap<String, LinkedList<String>>();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            List groups = (List)query.execute();
            for (MSentryGroup mGroup : groups) {
                for (MSentryRole role : mGroup.getRoles()) {
                    LinkedList<String> rUpdate = (LinkedList<String>)retVal.get(role.getRoleName());
                    if (rUpdate == null) {
                        rUpdate = new LinkedList<String>();
                        retVal.put(role.getRoleName(), rUpdate);
                    }
                    rUpdate.add(mGroup.getGroupName());
                }
            }
            this.commitTransaction(pm);
            HashMap<String, LinkedList<String>> hashMap = retVal;
            return hashMap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getGroupNameRoleNamesMap() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            List mSentryGroups = (List)query.execute();
            HashMap sentryGroupNameRoleNamesMap = Maps.newHashMap();
            if (mSentryGroups != null) {
                for (MSentryGroup mSentryGroup : mSentryGroups) {
                    String groupName = mSentryGroup.getGroupName();
                    HashSet roleNames = Sets.newHashSet();
                    for (MSentryRole mSentryRole : mSentryGroup.getRoles()) {
                        roleNames.add(mSentryRole.getRoleName());
                    }
                    if (roleNames.size() <= 0) continue;
                    sentryGroupNameRoleNamesMap.put(groupName, roleNames);
                }
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashMap hashMap = sentryGroupNameRoleNamesMap;
            return hashMap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap() throws Exception {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            List mSentryRoles = (List)query.execute();
            HashMap sentryRolePrivilegesMap = Maps.newHashMap();
            if (mSentryRoles != null) {
                for (MSentryRole mSentryRole : mSentryRoles) {
                    Set<TSentryPrivilege> privilegeSet = this.convertToTSentryPrivileges(mSentryRole.getPrivileges());
                    if (privilegeSet == null || privilegeSet.isEmpty()) continue;
                    sentryRolePrivilegesMap.put(mSentryRole.getRoleName(), privilegeSet);
                }
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashMap hashMap = sentryRolePrivilegesMap;
            return hashMap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private Set<String> getAllRoleNames(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryRole.class);
        List mSentryRoles = (List)query.execute();
        HashSet existRoleNames = Sets.newHashSet();
        if (mSentryRoles != null) {
            for (MSentryRole mSentryRole : mSentryRoles) {
                existRoleNames.add(mSentryRole.getRoleName());
            }
        }
        return existRoleNames;
    }

    private Map<String, MSentryGroup> getGroupNameTGroupMap(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryGroup.class);
        List mSentryGroups = (List)query.execute();
        HashMap existGroupsMap = Maps.newHashMap();
        if (mSentryGroups != null) {
            for (MSentryGroup mSentryGroup : mSentryGroups) {
                existGroupsMap.put(mSentryGroup.getGroupName(), mSentryGroup);
            }
        }
        return existGroupsMap;
    }

    private List<MSentryPrivilege> getPrivilegesList(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        List resultList = (List)query.execute();
        if (resultList == null) {
            resultList = Lists.newArrayList();
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected Map<String, MSentryRole> getRolesMap() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            List mSentryRoles = (List)query.execute();
            HashMap existRolesMap = Maps.newHashMap();
            if (mSentryRoles != null) {
                for (MSentryRole mSentryRole : mSentryRoles) {
                    existRolesMap.put(mSentryRole.getRoleName(), mSentryRole);
                }
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashMap hashMap = existRolesMap;
            return hashMap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected Map<String, MSentryGroup> getGroupNameTGroupMap() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Map<String, MSentryGroup> resultMap = this.getGroupNameTGroupMap(pm);
            this.commitTransaction(pm);
            rollbackTransaction = false;
            Map<String, MSentryGroup> map = resultMap;
            return map;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected List<MSentryPrivilege> getPrivilegesList() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            List<MSentryPrivilege> resultList = this.getPrivilegesList(pm);
            this.commitTransaction(pm);
            rollbackTransaction = false;
            List<MSentryPrivilege> list = resultList;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSentryMetaData(TSentryMappingData tSentryMappingData, boolean isOverwriteForRole) throws Exception {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        TSentryMappingData mappingData = this.lowercaseRoleName(tSentryMappingData);
        try {
            pm = this.openTransaction();
            Set<String> existRoleNames = this.getAllRoleNames(pm);
            Map<String, Set<TSentryGroup>> importedRoleGroupsMap = this.covertToRoleNameTGroupsMap(mappingData.getGroupRolesMap());
            Set<String> importedRoleNames = importedRoleGroupsMap.keySet();
            if (isOverwriteForRole) {
                this.dropDuplicatedRoleForImport(pm, existRoleNames, importedRoleNames);
                existRoleNames = this.getAllRoleNames(pm);
            }
            this.importSentryRolePrivilegeMapping(pm, existRoleNames, mappingData.getRolePrivilegesMap());
            this.importSentryGroupRoleMapping(pm, existRoleNames, importedRoleGroupsMap);
            this.commitTransaction(pm);
            rollbackTransaction = false;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private Map<String, Set<TSentryGroup>> covertToRoleNameTGroupsMap(Map<String, Set<String>> groupRolesMap) {
        HashMap roleGroupsMap = Maps.newHashMap();
        if (groupRolesMap != null) {
            for (String groupName : groupRolesMap.keySet()) {
                Set<String> roleNames = groupRolesMap.get(groupName);
                if (roleNames == null) continue;
                for (String roleName : roleNames) {
                    Set tSentryGroups = (Set)roleGroupsMap.get(roleName);
                    if (tSentryGroups == null) {
                        tSentryGroups = Sets.newHashSet();
                    }
                    tSentryGroups.add(new TSentryGroup(groupName));
                    roleGroupsMap.put(roleName, tSentryGroups);
                }
            }
        }
        return roleGroupsMap;
    }

    private void importSentryGroupRoleMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryGroup>> importedRoleGroupsMap) throws Exception {
        if (importedRoleGroupsMap == null || importedRoleGroupsMap.keySet() == null) {
            return;
        }
        for (String roleName : importedRoleGroupsMap.keySet()) {
            if (!existRoleNames.contains(roleName)) {
                this.createSentryRoleCore(pm, roleName);
            }
            this.alterSentryRoleAddGroupsCore(pm, roleName, importedRoleGroupsMap.get(roleName));
        }
    }

    private void dropDuplicatedRoleForImport(PersistenceManager pm, Set<String> existRoleNames, Set<String> importedRoleNames) throws Exception {
        Sets.SetView duplicatedRoleNames = Sets.intersection(existRoleNames, importedRoleNames);
        for (String droppedRoleName : duplicatedRoleNames) {
            this.dropSentryRoleCore(pm, droppedRoleName);
        }
    }

    private TSentryMappingData lowercaseRoleName(TSentryMappingData tSentryMappingData) {
        Map<String, Set<String>> sentryGroupRolesMap = tSentryMappingData.getGroupRolesMap();
        Map<String, Set<TSentryPrivilege>> sentryRolePrivilegesMap = tSentryMappingData.getRolePrivilegesMap();
        HashMap newSentryGroupRolesMap = Maps.newHashMap();
        HashMap newSentryRolePrivilegesMap = Maps.newHashMap();
        for (String groupName : sentryGroupRolesMap.keySet()) {
            Collection lowcaseRoles = Collections2.transform((Collection)sentryGroupRolesMap.get(groupName), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toString().toLowerCase();
                }
            });
            newSentryGroupRolesMap.put(groupName, Sets.newHashSet((Iterable)lowcaseRoles));
        }
        for (String roleName : sentryRolePrivilegesMap.keySet()) {
            newSentryRolePrivilegesMap.put(roleName.toLowerCase(), sentryRolePrivilegesMap.get(roleName));
        }
        tSentryMappingData.setGroupRolesMap(newSentryGroupRolesMap);
        tSentryMappingData.setRolePrivilegesMap(newSentryRolePrivilegesMap);
        return tSentryMappingData;
    }

    private void importSentryRolePrivilegeMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryPrivilege>> sentryRolePrivilegesMap) throws Exception {
        if (sentryRolePrivilegesMap != null) {
            for (String roleName : sentryRolePrivilegesMap.keySet()) {
                if (!existRoleNames.contains(roleName)) {
                    this.createSentryRoleCore(pm, roleName);
                    existRoleNames.add(roleName);
                }
                Set<TSentryPrivilege> tSentryPrivileges = sentryRolePrivilegesMap.get(roleName);
                for (TSentryPrivilege tSentryPrivilege : tSentryPrivileges) {
                    this.alterSentryRoleGrantPrivilegeCore(pm, roleName, tSentryPrivilege);
                }
            }
        }
    }

    private class PrivCleaner
    implements Runnable {
        private static final int NOTIFY_THRESHOLD = 50;
        private int currentNotifies = 0;
        private boolean exitRequired = false;
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();

        private PrivCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.lock.lock();
                try {
                    if (this.exitRequired) {
                        return;
                    }
                    while (this.currentNotifies <= 50) {
                        try {
                            this.cond.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!this.exitRequired) continue;
                        return;
                    }
                    this.currentNotifies = 0;
                }
                finally {
                    this.lock.unlock();
                }
                try {
                    this.removeOrphanedPrivileges();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Privilege cleaning thread encountered an error: " + e.getMessage());
                    continue;
                }
                break;
            }
        }

        public void incPrivRemoval(int numDeletions) {
            if (SentryStore.this.privCleanerThread != null) {
                this.lock.lock();
                this.currentNotifies += numDeletions;
                if (this.currentNotifies > 50) {
                    this.cond.signal();
                }
                this.lock.unlock();
            }
        }

        public void incPrivRemoval() {
            this.incPrivRemoval(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exit() {
            if (SentryStore.this.privCleanerThread != null) {
                this.lock.lock();
                try {
                    this.exitRequired = true;
                    this.cond.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOrphanedPrivileges() {
            Transaction transaction;
            String privDB = "SENTRY_DB_PRIVILEGE";
            String privId = "DB_PRIVILEGE_ID";
            String mapDB = "SENTRY_ROLE_DB_PRIVILEGE_MAP";
            String privFilter = "select DB_PRIVILEGE_ID from SENTRY_DB_PRIVILEGE p where not exists ( select 1 from SENTRY_ROLE_DB_PRIVILEGE_MAP d where p.DB_PRIVILEGE_ID != d.DB_PRIVILEGE_ID )";
            boolean rollback = true;
            int orphansRemoved = 0;
            ArrayList<Object> idList = new ArrayList<Object>();
            PersistenceManager pm = SentryStore.this.pmf.getPersistenceManager();
            try {
                transaction = pm.currentTransaction();
                transaction.begin();
                transaction.setRollbackOnly();
                Query query = pm.newQuery("javax.jdo.query.SQL", (Object)"select DB_PRIVILEGE_ID from SENTRY_DB_PRIVILEGE p where not exists ( select 1 from SENTRY_ROLE_DB_PRIVILEGE_MAP d where p.DB_PRIVILEGE_ID != d.DB_PRIVILEGE_ID )");
                query.setClass(MSentryPrivilege.class);
                List list = (List)query.execute();
                for (MSentryPrivilege orphan : list) {
                    idList.add(pm.getObjectId((Object)orphan));
                }
                transaction.rollback();
                rollback = false;
            }
            finally {
                if (rollback && pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                } else {
                    LOGGER.debug("Found {} potential orphans", (Object)idList.size());
                }
            }
            if (idList.isEmpty()) {
                pm.close();
                return;
            }
            Preconditions.checkState((!rollback ? 1 : 0) != 0);
            rollback = true;
            try {
                transaction = pm.currentTransaction();
                transaction.begin();
                pm.refreshAll();
                for (Object e : idList) {
                    MSentryPrivilege priv = (MSentryPrivilege)pm.getObjectById(e);
                    if (!priv.getRoles().isEmpty()) continue;
                    pm.deletePersistent((Object)priv);
                    ++orphansRemoved;
                }
                transaction.commit();
                pm.close();
                rollback = false;
            }
            finally {
                if (rollback) {
                    SentryStore.this.rollbackTransaction(pm);
                } else {
                    LOGGER.debug("Cleaned up {} orphaned privileges", (Object)orphansRemoved);
                }
            }
        }
    }
}

