/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class FixedJsonInstanceSerializer<T>
implements InstanceSerializer<T> {
    private final ObjectMapper mMapper;
    private final Class<T> mPayloadClass;

    public FixedJsonInstanceSerializer(Class<T> payloadClass) {
        this(payloadClass, new ObjectMapper());
    }

    public FixedJsonInstanceSerializer(Class<T> pPayloadClass, ObjectMapper pMapper) {
        this.mPayloadClass = pPayloadClass;
        this.mMapper = pMapper;
        this.mMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public byte[] serialize(ServiceInstance<T> pInstance) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.mMapper.writeValue((OutputStream)out, pInstance);
        return out.toByteArray();
    }

    private String getTextField(JsonNode pNode, String pFieldName) {
        Preconditions.checkNotNull((Object)pNode);
        Preconditions.checkNotNull((Object)pFieldName);
        return pNode.get(pFieldName) != null ? pNode.get(pFieldName).getTextValue() : null;
    }

    private Integer getIntegerField(JsonNode pNode, String pFieldName) {
        Preconditions.checkNotNull((Object)pNode);
        Preconditions.checkNotNull((Object)pFieldName);
        return pNode.get(pFieldName) != null && pNode.get(pFieldName).isNumber() ? Integer.valueOf(pNode.get(pFieldName).getIntValue()) : null;
    }

    private Long getLongField(JsonNode pNode, String pFieldName) {
        Preconditions.checkNotNull((Object)pNode);
        Preconditions.checkNotNull((Object)pFieldName);
        return pNode.get(pFieldName) != null && pNode.get(pFieldName).isLong() ? Long.valueOf(pNode.get(pFieldName).getLongValue()) : null;
    }

    private <O> O getObject(JsonNode pNode, String pFieldName, Class<O> pObjectClass) throws JsonParseException, JsonMappingException, IOException {
        Preconditions.checkNotNull((Object)pNode);
        Preconditions.checkNotNull((Object)pFieldName);
        Preconditions.checkNotNull(pObjectClass);
        if (pNode.get(pFieldName) != null && pNode.get(pFieldName).isObject()) {
            return (O)this.mMapper.readValue(pNode.get(pFieldName), pObjectClass);
        }
        return null;
    }

    public ServiceInstance<T> deserialize(byte[] pBytes) throws Exception {
        UriSpec uriSpec;
        ServiceType serviceType;
        T payload;
        Long registrationTimeUTC;
        Integer sslPort;
        Integer port;
        String name;
        String id;
        ByteArrayInputStream bais = new ByteArrayInputStream(pBytes);
        JsonNode rootNode = this.mMapper.readTree((InputStream)bais);
        ServiceInstanceBuilder builder = ServiceInstance.builder();
        String address = this.getTextField(rootNode, "address");
        if (address != null) {
            builder.address(address);
        }
        if ((id = this.getTextField(rootNode, "id")) != null) {
            builder.id(id);
        }
        if ((name = this.getTextField(rootNode, "name")) != null) {
            builder.name(name);
        }
        if ((port = this.getIntegerField(rootNode, "port")) != null) {
            builder.port(port.intValue());
        }
        if ((sslPort = this.getIntegerField(rootNode, "sslPort")) != null) {
            builder.sslPort(sslPort.intValue());
        }
        if ((registrationTimeUTC = this.getLongField(rootNode, "registrationTimeUTC")) != null) {
            builder.registrationTimeUTC(registrationTimeUTC.longValue());
        }
        if ((payload = this.getObject(rootNode, "payload", this.mPayloadClass)) != null) {
            builder.payload(payload);
        }
        if ((serviceType = this.getObject(rootNode, "serviceType", ServiceType.class)) != null) {
            builder.serviceType(serviceType);
        }
        if ((uriSpec = this.getObject(rootNode, "uriSpec", UriSpec.class)) != null) {
            builder.uriSpec(uriSpec);
        }
        return builder.build();
    }
}

