/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.appender;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class RollingFileWithoutDeleteAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    private long nextRollover = 0L;

    public RollingFileWithoutDeleteAppender() {
    }

    public RollingFileWithoutDeleteAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, RollingFileWithoutDeleteAppender.getLogFileName(filename), append);
    }

    public RollingFileWithoutDeleteAppender(Layout layout, String filename) throws IOException {
        super(layout, RollingFileWithoutDeleteAppender.getLogFileName(filename));
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        this.closeFile();
        String newFileName = RollingFileWithoutDeleteAppender.getLogFileName(this.fileName);
        try {
            this.setFile(newFileName, false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error((String)("setFile(" + newFileName + ", false) call failed."), (Throwable)e);
        }
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
        }
    }

    private static String getLogFileName(String oldFileName) {
        return oldFileName + "." + Long.toString(System.currentTimeMillis());
    }
}

